package cn.com.duiba.activity.center.api.dto.rob.category;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 功能描述:分类栏与应用关联对象(也称分类栏定向)
 *
 * @author sunchangji
 * @date 2016/10/19
 */
public class RobCategoryBarAppRelationDto implements Serializable {
    private static final long serialVersionUID = -6270543045726567571L;

    /**
     * 分类栏id
     */
    private Long barId;

    /**
     * 分类栏名称
     */
    private String barName;

    /**
     * 分类栏下包含的app列表信息
     * key:appId(应用id)
     * value:appName(应用名称)
     */
    private Map<Long, String> appIdAndAppNameMap;

    public RobCategoryBarAppRelationDto() {
        appIdAndAppNameMap = new HashMap<>();
    }

    public RobCategoryBarAppRelationDto(Long barId, String barName, Map<Long, String> appIdAndAppNameMap) {
        this.barId = barId;
        this.barName = barName;
        this.appIdAndAppNameMap = appIdAndAppNameMap;
    }

    public Long getBarId() {
        return barId;
    }

    public void setBarId(Long barId) {
        this.barId = barId;
    }

    public String getBarName() {
        return barName;
    }

    public void setBarName(String barName) {
        this.barName = barName;
    }

    public Map<Long, String> getAppIdAndAppNameMap() {
        return appIdAndAppNameMap;
    }

    public void setAppIdAndAppNameMap(Map<Long, String> appIdAndAppNameMap) {
        this.appIdAndAppNameMap = appIdAndAppNameMap;
    }
}
