package cn.com.duiba.activity.center.api.dto.rob.category;

import java.io.Serializable;
import java.util.Map;

/**
 * 功能描述:分类详细信息传输实体，包括该分类下活动信息
 *
 * @author sunchangji
 * @date 2016/10/19
 */
public class RobCategoryDetailDto implements Serializable {

    private static final long serialVersionUID = -8536909850095140049L;

    /**
     * 分类id
     */
    private Long categoryId;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 分类标题
     */
    private String title;

    /**
     * 该分类下对应的活动id和活动的排序值
     */
    private Map<Long, Integer> activitIdAndPayloadMap;

    public RobCategoryDetailDto(){}

    public RobCategoryDetailDto(Long categoryId,String name,String title,Map<Long, Integer> activitIdAndPayloadMap){
        this.categoryId = categoryId;
        this.name=name;
        this.title=title;
        this.activitIdAndPayloadMap = activitIdAndPayloadMap;
    }


    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<Long, Integer> getActivitIdAndPayloadMap() {
        return activitIdAndPayloadMap;
    }

    public void setActivitIdAndPayloadMap(Map<Long, Integer> activitIdAndPayloadMap) {
        this.activitIdAndPayloadMap = activitIdAndPayloadMap;
    }
}
