package cn.com.duiba.activity.center.api.remoteservice.activity_brick;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemotePopupActivityBrickBackendService.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月12日 下午2:43:16 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public interface RemotePopupActivityBrickBackendService {
	/**
	 * 插入签到皮肤
	 * @param PopupActivityBrickDto brick
	 */
	DubboResult<PopupActivityBrickDto> insert(PopupActivityBrickDto brick);

	/**
	 * 编辑签到皮肤
	 * @param PopupActivityBrickDto brick
	 * @return 操作结果
	 */
	DubboResult<Integer> update(PopupActivityBrickDto brick);

	/**
	 * 根据Id查询签到皮肤
	 * @param Integer id
	 * @return 签到皮肤
	 */
	DubboResult<PopupActivityBrickDto> findById(Long id);

	/**
	 * 删除签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	DubboResult<Integer> deleteById(Long id);

	/**
	 * 展示签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	DubboResult<Integer> showBrick(Long id);

	/**
	 * 隐藏签到皮肤
	 * @param id 皮肤ID
	 * @return 操作接口
	 */
	DubboResult<Integer> hiddenBrick(Long id);
	
	/**
	 * 查询皮肤list
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<List<PopupActivityBrickDto>> findPage(Integer type, Integer offset, Integer max);
	
	/**
	 * 查询皮肤满足条件的总条数
	 * @param map
	 * @return 操作结果
	 */
	DubboResult<Long> findPageCount(Integer type);
	
	/**
	 * 查询皮肤list
	 * @param id 签到ID
	 * @return 操作结果
	 */
	DubboResult<List<PopupActivityBrickDto>> findAll(Integer type);
	
	/**
	 * 根据Name查询签到皮肤
	 * @param Integer id
	 * @return 签到皮肤
	 */
	DubboResult<PopupActivityBrickDto> findByName(Integer type, String name);
	
	DubboResult<List<PopupActivityBrickDto>> findByCondition(Long appId, String name, Integer offset, Integer max);

	DubboResult<Long> findByConditionCount(Long appId, String name);
	
	DubboResult<Integer> updateLayoutBrickPosition(Long id, Integer position);
}
