/**
 * Project Name:activity-center-api
 * File Name:RemoteAdActivityService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.advertising
 * Date:2016年9月30日下午5:03:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.advertising;

import cn.com.duiba.activity.center.api.dto.advertising.AdActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdActivityService <br/>
 * Date:     2016年9月30日 下午5:03:56 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAdActivityService {
    /**
     * 获取指定活动ID的广告详细信息
     *
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return DuibaAdActivityDto 
     */
    DubboResult<AdActivityDto> queryByActivityId(Long activityId,Integer activityType);
    /**
     * 投放广告时上架活动
     *
     * @param appKey app唯一标识
     * @param activityId 活动ID
     * @param activityType 活动类型(OperatingActivityDto 中的常量定义)
     * @return operatingActivityId，活动打开url
     */
    DubboResult<AdActivityDto> addOnApp(Long activityId,Integer activityType,String appKey);
}

