/**
 * Project Name:activity-center-api
 * File Name:RemoteAdMaterialService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.advertising
 * Date:2016年10月10日上午10:44:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.advertising;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.advertising.DuibaAdMaterialDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdMaterialService <br/>
 * 物料信息接口
 * Date:     2016年10月10日 上午10:44:07 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAdMaterialService {
    /**
     * 根据素材ID获取物料实体
     *
     * @param materialId 素材Id
     * @return DuibaAdMaterialDto
     */
    DubboResult<DuibaAdMaterialDto> queryById(long materialId);
    
    /**
     * 
     * queryByIds:批量查询. <br/>
     *
     * @author wubo
     * @param ids
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<DuibaAdMaterialDto>> queryByIds(List<Long> ids);
 
    /**
     * 增加
     *
     * @param DuibaAdMaterialDto
     * @return DuibaAdMaterialDto
     */
    DubboResult<DuibaAdMaterialDto> add(DuibaAdMaterialDto dto);
 
    /**
     * 更新
     *
     * @param materialId 素材Id
     * @return Boolean
     */
    DubboResult<Boolean> update(DuibaAdMaterialDto dto);
 
    /**
     * 根据素材ID删除实例
     *
     * @param materialId 素材Id
     * @return Boolean
     */
    DubboResult<Boolean> deleteById(long materialId);
    
    /** 
     * queryByActivity:根据活动id，活动type查询. <br/>
     *
     * @param activityId
     * @param activityType
     * @return dto
     */
    DubboResult<DuibaAdMaterialDto> queryByActivity(Long activityId,Integer activityType);
}

