package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersDto;
import cn.com.duiba.activity.center.api.dto.game.GameOrdersSimpleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by ZQian on 2016/8/1.
 */
public interface RemoteGameOrdersSimpleService {
    public DubboResult<GameOrdersDto> find(Long gameOrderId);

    public DubboResult<GameOrdersDto> findByAppAndDeveloperBizId(Long appId, String bizId);

    public DubboResult<List<GameOrdersDto>> findByIds(List<Long> ids);

    public DubboResult<GameOrdersDto> insert(GameOrdersDto gameOrdersDO);

    public DubboResult<Integer> findConsumerFreeNumber(Long consumerId, Long operatingActivityId);

    public DubboResult<Integer> findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    public DubboResult<Integer> findConsumerLimitNumber(Long consumerId, Long operatingActivityId);

    public DubboResult<Integer> findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    public DubboResult<Integer> countConsumerByPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

    public DubboResult<Integer> countConsumerByGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);

    public DubboResult<List<Long>> findOverdueOrder();

    public DubboResult<Long> countRow(Map<String, Object> params);

    public DubboResult<List<GameOrdersSimpleDto>> findByLimit(Map<String, Object> params);

    public DubboResult<List<DeveloperActivityStatisticsDto>> countFailByOperatingActivityIds(List<Long> ids);
}
