/**
 * Project Name:activity-center-api File Name:RemoteGameSkinService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.gameskin Date:2016年9月29日下午3:11:06 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.activity.center.api.remoteservice.gameskin;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameSkinService <br/>
 * 游戏皮肤接口(积分游戏,小游戏公用) <br/>
 * Date: 2016年9月29日 下午3:11:06 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteGameSkinService {

    /**
     * 
     * find. <br/>
     * 根据id查询
     * @author wubo
     * @param id
     * @return dto
     */
    DubboResult<GameSkinDto> find(Long id);

    /**
     * findPage:分页查询. <br/>
     * 
     * @author wubo
     * @param pagingParameters
     * @param types 皮肤类型，可多选，可不选
     * @return dto
     */
    DubboResult<List<GameSkinDto>> findPage(PagingParameters pagingParameters,List<Byte> types);

    /**
     * findByType. <br/>
     * 根据类型，查询所有
     * @author wubo
     * @param type
     * @return list<GameSkinDto>
     */
    DubboResult<List<GameSkinDto>> findByType(Byte type);

    /**
     * add. <br/>
     * 添加皮肤
     * @author wubo
     * @param dto
     * @return id
     */
    DubboResult<Long> add(GameSkinDto dto);

    /**
     * edit. <br/>
     * 编辑
     * @author wubo
     * @param dto
     * @return
     */
    DubboResult<Long> edit(GameSkinDto dto);

    /**
     * isTitleExist. <br/>
     * 查询title是否存在
     * @author wubo
     * @param name
     * @return boolean
     */
    DubboResult<Boolean> isTitleExist(String name);

    /**
     * findCount. <br/>
     * 统计
     * @author wubo
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> findCount(List<Byte> types);
    
    /**
     * describe : 根据皮肤ID查询皮肤
     * @author  : cdm
     * @date    : 2016年10月18日下午5:33:13
     * @param id  皮肤ID
     */
    DubboResult<String> getBrickContentById(final Long id);
    
    /**
     * describe : 查询不带皮肤内容的皮肤实体
     * @author  : cdm
     * @date    : 2016年10月18日下午5:40:59
     * @param id 皮肤ID
     */
    DubboResult<GameSkinDto> findNoContent(final Long id);
}
