package cn.com.duiba.activity.center.api.remoteservice.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDetailDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 描述:今日必抢分类相关逻辑操作接口
 *
 * @author :sunchangji
 * @create :2016-10-17 17:42
 */
public interface RemoteRobCategoryService {
    /**
     * 查询所有分类
     *
     * @return
     */
    DubboResult<List<RobCategoryDto>> getAllCategory();

    /**
     * 根据appId获取app今日必抢分类列表
     *
     * @param appId 应用id
     * @return
     */
    DubboResult<List<RobCategoryDto>> getByAppId(Long appId);

    /**
     * 根据分类id分页查询分类下开启且可见的活动
     *
     * @param categoryId 活动id
     * @param offset     偏移量
     * @param pageSize   页距
     * @return
     */
    DubboResult<List<TodayRobConfigDto>> getByCategoryId(Long categoryId, int offset, int pageSize);

    /**
     * 根据分类id查询分类下所有开启且可见和关闭且可见的活动
     *
     * @param categoryId 活动id
     * @return
     */
    DubboResult<List<RobActivityDto>> getForManageByCategoryId(Long categoryId);

    /**
     * 批量获取分类信息，通过分类id的集合
     *
     * @param categoryIdList 分类id的集合
     * @return 返回结果顺序是根据分类id集合中的顺序排列的
     */
    DubboResult<List<RobCategoryDto>> getCategoryByCategoryIds(List<Long> categoryIdList);

    /**
     * 分页查询分类列表,支持多条件查询(条件没有查询的是全部)
     *
     * @param name     分类名
     * @param title    分类标题
     * @param offset   偏移量
     * @param pageSize 页距
     * @return
     */
    DubboResult<List<RobCategoryDto>> getCategoryPage(String name, String title, Integer offset, Integer pageSize);

    /**
     * 查询总记录数，支持多条件查询，如果条件都为空则查询的是全部记录数
     *
     * @param name  分类名称
     * @param title 分类标题
     * @return 总条数
     */
    DubboResult<Integer> countByNameAndTitle(String name, String title);

    /**
     * 根据分类id删除分类
     * 1.如果是id=1禁止删除
     * 2.根据分类id删除分类栏与分类关联表相中关数据
     * 3.根据分类id删除分类栏与活动关联表中相关数据
     * 4.根据分类id删除分类
     *
     * @param id 分类id
     * @return
     */
    DubboResult<Boolean> deleteById(Long id);

    /**
     * 新增分类
     *
     * @param robCategoryDetailDto 新增分类数据
     * @return
     */
    DubboResult<Boolean> insertCategory(RobCategoryDetailDto robCategoryDetailDto);

    /**
     * 批量删除分类与活动关联表数据
     *
     * @param categoryId
     * @param activityIds
     * @return
     */
    DubboResult<Boolean> batchDeleteCategoryActivityRelation(Long categoryId, List<Long> activityIds);

    /**
     * 批量更新分类与活动关联表中对应排序值
     *
     * @return
     */
    DubboResult<Boolean> batchUpdateRobCategoryActivityRelationPayload(RobCategoryDetailDto robCategoryDetailDto);


}
