package cn.com.duiba.activity.center.api.dto.hdtool;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * ClassName: HdtoolStockConsumeDto <br/>
 * date: 2016年12月1日 上午9:34:01 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public class HdtoolStockConsumeDto implements Serializable {
	private static final long serialVersionUID = -7560015999674302687L;

	public static final String ACTION_PAY = "pay";
	public static final String ACTION_BACK = "back";
	public static final String TYPE_DUIBA = "duiba";
	public static final String TYPE_APP = "app";
	public static final String BIZ_SOURCE_NORMAL = "normal";//活动工具普通订单

	private Long id;
	private Long relationId;
	private String relationType;
	private String bizId;
	private String bizSource;
	private String action;
	private Long quantity;
	private Long appId;
	private Date gmtCreate;
	private Date gmtModified;
	
	/**
	 * 
	 * Creates a new instance of HdtoolStockConsumeDto.
	 *
	 * @param init4insert
	 */
	public HdtoolStockConsumeDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	/**
	 * 
	 * Creates a new instance of HdtoolStockConsumeDto.
	 *
	 */
	public HdtoolStockConsumeDto() {
	}

	/**
	 * 
	 * Creates a new instance of HdtoolStockConsumeDto.
	 *
	 * @param id
	 */
	public HdtoolStockConsumeDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public String getRelationType() {
		return relationType;
	}

	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public Long getQuantity() {
		return quantity;
	}

	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getBizSource() {
		return bizSource;
	}

	public void setBizSource(String bizSource) {
		this.bizSource = bizSource;
	}
	
	
}
