package cn.com.duiba.activity.center.api.enums;

import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.GAME_TYPES;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeAppManualLottery;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeAppSingleLottery;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaActivity;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaCreditGame;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaElasticGifts;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaGuess;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaLittleGame;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaNgame;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaQuestionAnswer;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaQuizz;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaRob;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaSeckill;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaSingleLottery;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeDuibaTurntable;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeHdToolSmashg;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypePlugin;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeSecondsKill;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeSign;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.TypeTurnTable;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.hdToolTypeSet;
import static cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto.questionTypeSet;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.exception.ActivityTypeException;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @author 刘瑶
 * 活动类型TYPE
 * 新创建的活动工具现在已经全部统一类型,全部换成砸金蛋
 * 但我们约定,WEB不出现具体活动type,兼容逻辑全部在活动中心处理
 * 一种枚举类型对应一个活动库实例
 */
public enum ActivityTypeEnum{

    ACTIVITY_TOOL(TypeHdToolSmashg,"活动工具"),
    ZHANGTI_ACTIVITY(TypeDuibaActivity,"专题活动"),
    QUESTION_ANSWER(TypeDuibaQuestionAnswer,"答题活动"),
    SECONDS_KILL(TypeSecondsKill,"秒杀专题"),
    SECONDS_ACTIVITY(TypeDuibaSeckill,"兑吧秒杀活动"),
    QUIZZ(TypeDuibaQuizz,"测试题"),
    GAME(TypeDuibaNgame,"游戏"),
    GUESS(TypeDuibaGuess,"竞猜活动"),
    CREDIT_GAME(TypeDuibaCreditGame,"积分游戏"),
    LITTLE_GAME(TypeDuibaLittleGame,"小游戏"),
    ROB(TypeDuibaRob,"今日必抢"),
    PLUGIN(TypePlugin,"插件活动"),
    SINGLE_LOTTERY(TypeDuibaSingleLottery,"兑吧单品抽奖"),
    APP_SINGLE_LOTTERY(TypeAppSingleLottery,"自有单品抽奖"),
    MANUAL_LOTTERY(TypeAppManualLottery,"手动开奖"),
    SIGN(TypeSign,"签到活动"),
    TURNTABLE(TypeTurnTable,"大转盘"),
    DUIBA_TURNTABLE(TypeDuibaTurntable,"兑吧大转盘"),
    ELASTIC_GIFTS(TypeDuibaElasticGifts,"弹层活动");

    private static final HashMultimap<ActivityTypeEnum,Integer> TYPE_MAP = HashMultimap.create();
    //反向Map
    private static final Map<Integer,ActivityTypeEnum> REVERSE_MAP = Maps.newHashMap();
    static{
        TYPE_MAP.putAll(ACTIVITY_TOOL,hdToolTypeSet);
        TYPE_MAP.putAll(GAME,GAME_TYPES);
        TYPE_MAP.put(ZHANGTI_ACTIVITY,TypeDuibaActivity);
        TYPE_MAP.putAll(QUESTION_ANSWER,questionTypeSet);
        TYPE_MAP.put(SECONDS_KILL,SECONDS_KILL.getType());
        TYPE_MAP.put(SECONDS_ACTIVITY,SECONDS_ACTIVITY.getType());
        TYPE_MAP.put(QUIZZ,QUIZZ.getType());
        TYPE_MAP.put(GUESS,GUESS.getType());
        TYPE_MAP.put(CREDIT_GAME,CREDIT_GAME.getType());
        TYPE_MAP.put(LITTLE_GAME,LITTLE_GAME.getType());
        TYPE_MAP.put(ROB,ROB.getType());
        TYPE_MAP.put(PLUGIN,PLUGIN.getType());
        TYPE_MAP.put(SINGLE_LOTTERY,SINGLE_LOTTERY.getType());
        TYPE_MAP.put(APP_SINGLE_LOTTERY,APP_SINGLE_LOTTERY.getType());
        TYPE_MAP.put(SIGN,SIGN.getType());
        TYPE_MAP.put(TURNTABLE,TURNTABLE.getType());
        TYPE_MAP.put(DUIBA_TURNTABLE,DUIBA_TURNTABLE.getType());
        TYPE_MAP.put(ELASTIC_GIFTS,ELASTIC_GIFTS.getType());

        //****************************自动给反向MAP填值***********************
        for(ActivityTypeEnum typeEnum : TYPE_MAP.keySet()){
            for(Integer type:TYPE_MAP.get(typeEnum)){
                REVERSE_MAP.put(type,typeEnum);
            }
        }
    }

    /**
     * 一般只在的活动中心调用
     * 获取该枚举下对应的所有活动类型
     * @return
     */
    public List<Integer> getSuportActivityTypeList() {
        return Lists.newArrayList(TYPE_MAP.get(this));
    }

    private Integer type;

    private String name;

    ActivityTypeEnum(Integer type,String name){
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public Integer getType() {
        return type;
    }

    /**
     * 获取活动类型枚举类(在WEB端尽量只出现活动枚举类)
     * 主要维护ActivityTypeEnum 和 type的对应关系
     * 这个方法暂时只列出楼层,主会场,子页面等所有会在运营位上出现的活动类型,这些活动都是走活动适配层的
     * 如果后面阁下也认为活动适配层能简化代码,可以换一下心情,来一次轰轰烈烈的重构
     * @return
     */
    public static ActivityTypeEnum getEnumType(Integer type){
        if(!REVERSE_MAP.containsKey(type)){
            throw new ActivityTypeException(type);
        }
        return REVERSE_MAP.get(type);
    }
}
