package cn.com.duiba.activity.center.api.remoteservice.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
public interface RemoteGuessOrdersService {
    public List<GuessOrdersDto> findWinByGuessIdAndPrizeId(Long duibaGuessId, Long prizeId);

    /**
     * 
     * findWinOrderByExactMatch:(这里用一句话描述这个方法的作用). <br/>
     * 精确匹配获取中奖名单
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData);
    
    /**
     * 
     * findWinOrderByVagueMatch:(这里用一句话描述这个方法的作用). <br/>
     * 模糊匹配获取中奖名单
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData);


    //from manager

    /**
     * 
     * findExpireOrder:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findExpireOrder();
    
    /**
     * 
     * findWinOrderByExactMatch:(这里用一句话描述这个方法的作用). <br/>
     * 精确匹配获取中奖名单
     * @param duibaGuessId
     * @param winIds
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByExactMatch(Long duibaGuessId, List<String> winIds, String guessData, Integer offset, Integer max, Long consumerId);
    
    /**
     * 
     * findWinOrderByVagueMatch:(这里用一句话描述这个方法的作用). <br/>
     * 模糊匹配获取中奖名单
     * @param duibaGuessId
     * @param num
     * @param luckNum
     * @param guessData
     * @param offset
     * @param max
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrderByVagueMatch(Long duibaGuessId, int num, String luckNum, String guessData, Integer offset, Integer max, Long consumerId);
}
