package cn.com.duiba.activity.center.api.remoteservice.recommend;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.recommend.RecommendSkinDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 管理端-推荐位皮肤
 * Created by zhengjy on 2017/2/7.
 */
public interface RemoteRecommendSkinBackendService {
    /**
     * 列表查询
     * @param recommendSkinDto
     * @return
     */
    DubboResult<List<RecommendSkinDto>> findList(RecommendSkinDto recommendSkinDto);
    /**
     * 分页查询
     * @param recommendSkinDto
     * @return
     */
    DubboResult<PaginationDto<RecommendSkinDto>> findPageList(int pageNum, int pageSize, RecommendSkinDto recommendSkinDto);

    /**
     * 添加
     * @param recommendSkinDto
     * @return
     */
    DubboResult<Long> insert(RecommendSkinDto recommendSkinDto);

    /**
     * 更新
     * @param recommendSkinDto
     * @return
     */
    DubboResult<Boolean> update(RecommendSkinDto recommendSkinDto);

    /**
     *  查询
     * @param id
     * @return
     */
    DubboResult<RecommendSkinDto> find(Long id);

    /**
     * 删除
     * @param id
     * @return
     */
    DubboResult<Boolean> delete(Long id);
}
