package cn.com.duiba.activity.center.api.remoteservice.singlelottery;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;

import java.util.List;

/**
 * Created by yansen on 16/6/20.
 */
public interface RemoteSingleLotteryServiceNew {
    //以下方法来自 SingleLotterySimpleDAO

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询
     * @param id
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto find(Long id);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID集合查询开发者单品抽奖
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids);

    //以下方法来自 AppSingleLotteryStatusChangeDAO

    /**
     * 
     * addMainAppItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 增加主奖品的数量
     * @param id
     * @param addMainAppItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining);

    /**
     * 
     * subMainAppItemRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 减少主奖品的数量
     * @param id
     * @param subMainAppItemRemaining
     * @return
     * @since JDK 1.6
     */
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining);


    //以下方法来自SingleLotteryTextChangeDAO

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 新增开发者单品抽奖
     * @param appSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto insert(AppSingleLotteryDto appSingleLotteryDO);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID修改
     * @param appSingleLotteryDO
     * @return
     * @since JDK 1.6
     */
    public int update(AppSingleLotteryDto appSingleLotteryDO);

    /**
     * 
     * reduceMainAppItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 减主奖品剩余个数
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int reduceMainAppItemRemaining(Long id);

    /**
     * 
     * addMainAppItemRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 加主奖品剩余个数
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int addMainAppItemRemaining(Long id);

    /**
     * 
     * updateForDevEdit:(这里用一句话描述这个方法的作用). <br/>
     * 开发者后台更新
     * @param appSingleLottery
     * @return
     * @since JDK 1.6
     */
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery);

    /**
     * 
     * findRemaingForupdate:(这里用一句话描述这个方法的作用). <br/>
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer findRemaingForupdate(Long id);

    /**
     * 
     * findForupdate:(这里用一句话描述这个方法的作用). <br/>
     * @param id
     * @return
     * @since JDK 1.6
     */
    public AppSingleLotteryDto findForupdate(Long id);
    }
