package cn.com.duiba.activity.center.api.remoteservice.flow;

import cn.com.duiba.activity.center.api.dto.flow.ActivityFlowRuleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * Created by zzy on 2017/4/19.
 */
public interface RemoteActivityFlowRuleBackendService {
    /**
     * 修改流量配置
     * id必填
     *
     * @param activityFlowRuleDto
     * @return
     */
    DubboResult<Boolean> update(ActivityFlowRuleDto activityFlowRuleDto);

    /**
     * 新增流量配置
     *
     * @param activityFlowRuleDto
     * @return
     */
    DubboResult<Long> insert(ActivityFlowRuleDto activityFlowRuleDto);

    /**
     * 根据唯一索引查询配置
     *
     * @param appId
     * @param ruleType
     * @param activityType
     * @return
     */
    DubboResult<ActivityFlowRuleDto> findByKey(Long appId, Integer ruleType, Integer activityType);
}
