package cn.com.duiba.activity.center.api.dto.direct;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by suyuanlong on 16/7/14.
 * 活动开发者黑名单dto类
 */
public class ActivityBlackList4DeveloperDto implements Serializable {

    private static final long serialVersionUID = -653433883874667095L;

    //活动以0为起点，也就是与operating的type值相同
    public static final int TypeDuibaActivity = 0; //专题活动
    public static final int TypeTurnTable = 1; // 大转盘活动
    public static final int TypeDuibaSingleLottery = 2; // 兑吧单品抽奖
    public static final int TypeAppSingleLottery = 3; // App自有单品抽奖
    public static final int TypeDuibaTurntable = 4; //兑吧大转盘
    public static final int TypeAppManualLottery = 5; //app自有手动开奖
    public static final int TypeShakeLottery = 6;//摇一摇
    public static final int TypeScratchCard = 7;//刮刮卡
    public static final int TypeHdToolTurntable = 8;//活动工具大转盘
    public static final int TypeHdToolTiger = 9;//老虎机
    public static final int TypeHdToolFlop = 11;//趣味翻牌
    public static final int TypeHdToolSmashg = 12;//砸彩蛋
    public static final int TypeItem = 10;//兑换项
    public static final int TypeSecondsKill = 30;//周三必抢（秒杀专题）
    public static final int TypeGameSanta = 20;//游戏活动-打劫圣诞老人
    public static final int TypeGameYearAward = 21;//游戏活动-数年终奖
    public static final int TypeGameGirl = 22;//游戏活动-女神pk女汉子
    public static final int TypeGameJiong = 23;//游戏活动-人在囧途

    public static final int TypeDuibaQuestionAnswer = 40;	// 兑吧答题
    public static final int TypeDuibaQuizz = 41;	// 兑吧测试题
    public static final int TypeDuibaSeckill = 31;	// 兑吧秒杀活动
    public static final int TypeDuibaRob = 45;//今日必抢
    public static final int TypeDuibaCreditGame = 46;//积分游戏
    public static final int TypeDuibaLittleGame = 47;//小游戏

    //签到体系活动以10000为起点
    public static final int TypeSignSystemActivity = 10001;//签到体系活动

    private Long id;
    private Long activityId;  //活动id
    private Long developerId; //开发者id
    private Integer activityType;
    private Date gmtCteate;
    private Date gmtModified;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Date getGmtCteate() {
        return gmtCteate;
    }

    public void setGmtCteate(Date gmtCteate) {
        this.gmtCteate = gmtCteate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static int getHdToolTypeByDuibaType(int duibaType){
        if(duibaType == 1){
            return TypeShakeLottery;
        }else if(duibaType ==2){
            return TypeScratchCard;
        }else if(duibaType == 3){
            return TypeHdToolTurntable;
        }else if(duibaType == 4){
            return TypeHdToolTiger;
        }else if(duibaType == 5){
            return TypeHdToolFlop;
        }else if(duibaType == 6){
            return TypeHdToolSmashg;
        }
        return -1;
    }

}
