package cn.com.duiba.activity.center.api.dto.guess;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * ClassName: GuessPrizeDto <br/>
 * date: 2016年11月30日 下午8:56:19 <br/>
 *
 * @author liyang
 * @version
 * @since JDK 1.6
 */
public class GuessPrizeDto implements Serializable {
	private static final long serialVersionUID = 226917798329524651L;

	private Long id;
	private Long duibaGuessId;
	private Long itemId;
	private Long appItemId;
	private String name;
	private Integer payload;
	private String prizeType;
	private Long facePrice;
	private Integer limitCount;
	private Integer hidden;
	private String logo;
	private String description;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;
	private String scope;
	private Integer scopeStart;
	private Integer scopeEnd;
	private Integer autoOpen;
	private Integer remaining;

	/**
	 *
	 * Creates a new instance of GuessPrizeDto.
	 *
	 */
	public GuessPrizeDto() {
	}

	/**
	 *
	 * Creates a new instance of GuessPrizeDto.
	 *
	 * @param duibaGuessOption
	 */
	public GuessPrizeDto(DuibaGuessOptionsDto duibaGuessOption) {
		this.id = duibaGuessOption.getId();
		this.duibaGuessId = duibaGuessOption.getDuibaGuessId();
		this.itemId = duibaGuessOption.getItemId();
		this.name = duibaGuessOption.getPrizeName();
		this.payload = duibaGuessOption.getPayload();
		this.prizeType = duibaGuessOption.getPrizeType();
		this.facePrice = duibaGuessOption.getFacePrice();
		this.hidden = duibaGuessOption.getHidden();
		this.logo = duibaGuessOption.getLogo();
		this.description = duibaGuessOption.getDescription();
		this.deleted = duibaGuessOption.getDeleted();
		this.gmtCreate = duibaGuessOption.getGmtCreate();
		this.gmtModified = duibaGuessOption.getGmtModified();
		this.autoOpen = duibaGuessOption.getAutoOpen();
		this.remaining = duibaGuessOption.getRemaining();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}


	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public Integer getHidden() {
		return hidden;
	}

	public void setHidden(Integer hidden) {
		this.hidden = hidden;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public Integer getScopeEnd() {
		return scopeEnd;
	}

	public void setScopeEnd(Integer scopeEnd) {
		this.scopeEnd = scopeEnd;
	}

	public Integer getScopeStart() {
		return scopeStart;
	}

	public void setScopeStart(Integer scopeStart) {
		this.scopeStart = scopeStart;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Long getDuibaGuessId() {
		return duibaGuessId;
	}

	public void setDuibaGuessId(Long duibaGuessId) {
		this.duibaGuessId = duibaGuessId;
	}

	public Long getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Long facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getAutoOpen() {
		return autoOpen;
	}

	public void setAutoOpen(Integer autoOpen) {
		this.autoOpen = autoOpen;
	}
	
}
