package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterRuntimeException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public enum SignActivitySkinStatusEnum {
    STATUS_OPEN(1,"开启"),
    STATUS_CLOSE(2,"隐藏");

    private Integer code;
    private String desc;

    private static Map<Integer,SignActivitySkinStatusEnum> typeMap = new HashMap<>();
    static{
        for(SignActivitySkinStatusEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    SignActivitySkinStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static SignActivitySkinStatusEnum getSignTypeByCode(Integer code){
        if(code == null || !typeMap.containsKey(code)){
            throw new ActivityCenterRuntimeException("不支持的签到皮肤状态，status="+code);
        }
        return typeMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
