/**
 * Project Name:activity-center-api File Name:RemoteGameCenterService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.gamecenter Date:2016年10月17日上午11:10:03 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.api.remoteservice.gamecenter;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameCenterService <br/>
 * Function: 游戏中心Dubbo服务. <br/>
 * Date: 2016年10月17日 上午11:10:03 <br/>
 *
 * @author zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface RemoteGameCenterService {

    
    /**
     * 
     * findResourceByLocationAndAppId:(这里用一句话描述这个方法的作用). <br/>
     * 查询积分商城游戏主页的资源列表
     * @param locationName
     * @param appId
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    DubboResult<GameCenterHomeResourceListDto> findResourceByLocationAndAppId(String locationName, Long appId,
                                                                              Integer offset, Integer max);

    /**
     * findGameForHomeFloor:首页游戏楼层查询小游戏列表. <br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<LittleGameResourceListDto> findGameForHomeFloor(Long appId, Integer offset, Integer max);
}
