package cn.com.duiba.activity.center.api.remoteservice.guess;


import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 
 * ClassName: RemoteDuibaGuessServiceNew <br/>
 * date: 2016年12月1日 下午3:04:25 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaGuessServiceNew {

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	public DuibaGuessDto find(Long id);
	/**
	 * 
	 * findTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public String findTagById(Long id);
	/**
	 * 
	 * updateTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param tag
	 * @return
	 * @since JDK 1.6
	 */
	public int updateTagById(Long id, String tag);
	
	/**
	 * 
	 * findByPage:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param offset
	 * @param max
	 * @param title
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaGuessDto> findByPage(Integer offset, Integer max, String title, Integer id);
	
	/**
	 * 
	 * findPageCount:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param title
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public Long findPageCount(String title, Integer id);
	/**
	 * 
	 * updateStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param status
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStatus(Long id, int status);
	
	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int delete(Long id);
	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param DuibaGuessDto
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaGuessDto insert(DuibaGuessDto DuibaGuessDto);
	/**
	 * 
	 * updateInfoForm:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param DuibaGuessDto
	 * @return
	 * @since JDK 1.6
	 */
	public int updateInfoForm(DuibaGuessDto DuibaGuessDto);
	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param autoOffDate
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateAutoOffDateNull(Date autoOffDate, Long id);
	
	/**
	 * 
	 * updateSwitches:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param switches
	 * @since JDK 1.6
	 */
	public void updateSwitches(Long id, Integer switches);
	
	/**
	 * 
	 * updateOpenWinning:(这里用一句话描述这个方法的作用). <br/>
	 * 修改开奖后的主表信息
	 * @param id
	 * @param luckNum
	 * @param rightSelectionId
	 * @param isAccurate
	 * @since JDK 1.6
	 */
	public void updateOpenWinning(Long id, String luckNum, Long rightSelectionId, Integer isAccurate);

	/**
	 * 
	 * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaGuessDto> findAllByIds(List<Long> ids);

	/**
	 * 
	 * findAllGuess:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<AddActivityDto> findAllGuess(Long appId);

	/**
	 * 
	 * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaGuessDto> findAutoOff();

	/**
	 * 
	 * updateOpenPrize:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateOpenPrize(Long id);

	public DubboResult<Long> addDuibaGuessToDeveloper(Long appId, Long duibaGuessId);

}
