package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignActivitySkinDto;
import cn.com.duiba.activity.center.api.enums.SignActivitySkinStatusEnum;
import cn.com.duiba.activity.center.api.enums.SignActivityTypeEnum;
import cn.com.duiba.activity.center.api.params.SignActivitySkinQueryParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
public interface RemoteSignActivitySkinService {
    /**
     * 新增签到体系活动皮肤，保存成功返回皮肤ID
     *
     * @param dto
     * @return 活动ID
     */
    DubboResult<Long> insert(SignActivitySkinDto dto);

    /**
     * 删除签到活动皮肤
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteSignActivitySkin(long id);

    /**
     * 更新指定ID的签到活动信息,不更新null值
     *
     * @param dto id非空
     * @return
     */
    DubboResult<Boolean> updateByIdUnNULL(SignActivitySkinDto dto);

    /**
     * 根据ID查询签到活动皮肤
     *
     * @param id
     * @return
     */
    DubboResult<SignActivitySkinDto> find(long id);

    /**
     * 获取给定类型下的一个签到活动皮肤
     *
     * @param signType
     * @return
     */
    DubboResult<SignActivitySkinDto> findOneByType(SignActivityTypeEnum signType);

    /**
     * 查询指定类型下给定app可用的签到活动皮肤，根据定向做过滤
     *
     * @param appId 非空
     * @return
     */
    DubboResult<List<SignActivitySkinDto>> findByTypeAndAppId(SignActivityTypeEnum signType, long appId);

    /**
     * 分页查询签到活动,分页信息非空
     *
     * @param param
     * @return
     */
    DubboResult<Page<SignActivitySkinDto>> pageSearch(SignActivitySkinQueryParam param);

    /**
     * 更新签到活动皮肤状态
     *
     * @param id
     * @param status
     * @return
     */
    DubboResult<Boolean> updateStatus(long id, SignActivitySkinStatusEnum status);

    /**
     * 定向开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    DubboResult<Boolean> directSwitch(long id, boolean switchOpen);
}
