package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignRuleDto;
import cn.com.duiba.activity.center.api.enums.ConstellationTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignActivityTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 签到活动规则
 * Created by xiaoxuda on 2017/4/21.
 */
public interface RemoteSignRuleService {
    /**
     * 批量插入规则
     *
     * @param signType       活动类型，必填
     * @param signActivityId 活动ID,必填
     * @param list
     * @return
     */
    DubboResult<Boolean> batchInsert(SignActivityTypeEnum signType, long signActivityId,
                                     List<? extends SignRuleDto> list);

    /**
     * 通过签到活动类型与活动id查询关联的所有活动规则,按签到日期倒叙排列
     *
     * @param signType
     * @param signActivityId
     * @return
     */
    DubboResult<List<SignRuleDto>> findByTypeAndActivityIdOrderByDayDesc(SignActivityTypeEnum signType,
                                                                         long signActivityId);

    /**
     * 通过星座类型与活动id及日期，查询对应签到星座规则
     *
     * @param constellationType
     * @param signActivityId
     * @param signDate       yyyy-MM-dd格式
     * @return
     */
    DubboResult<SignRuleDto> findByConstellationTypeAndActivityIdAndDay(long signActivityId,
                                                                        ConstellationTypeEnum constellationType,
                                                                        String signDate);


}
