package cn.com.duiba.activity.center.api.dto.singlelottery;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/6/23.
 */
public class SingleLotteryOrderDto implements Serializable{
    private static final long serialVersionUID = 8740165197245852618L;

    public static final String PREFIX_ORDER = "singlelottery-";

    public static final int StatusCreate = 0; // 创建
    public static final int StatusSuccess = 1;// 处理成功
    public static final int StatusFail = 2;// 处理失败

    public static final int ExchangeStatusCreate = 0;//创建
    public static final int ExchangeStatusWait = 1;// 待领奖
    public static final int ExchangeStatusSuccess = 2; // 领奖成功
    public static final int ExchangeStatusFail = 3;// 领奖失败
    public static final int ExchangeStatusOverdue = 4;// 未领奖，过期

    public static final int OptionTypeNo = 0;//未中奖
    public static final int OptionTypeBig = 1;//大奖
    public static final int OptionTypeSmall = 2;//小奖

    private Long id;
    private Long operatingActivityId;//开发者活动ID
    private Long appId;//开发者appId
    private Long consumerId;//用户ID
    private Long credits;//积分
    private Integer optionType;//奖项类型    0：未中奖  1：大奖    2:小奖
    private String prizeName;//奖项名称
    private Long itemId;//奖项ItemID
    private Long appItemId;//奖项AppItemID
    private String prizeType;//奖项子类型   如：话费，Q币，支付宝等  引用 ItemDO type
    private Integer prizeFacePrice;//奖项面额
    private String prizeDegree;//虚拟商品档位
    private Long couponId;//优惠券
    private String developerBizId;//开发者订单号
    private Integer status;//订单状态    0：创建 1：处理成功 2：处理失败
    private String error4admin;//admin错误信息
    private String error4developer;//developer错误信息
    private String error4consumer;//consumer错误信息
    private Integer exchangeStatus;//兑换状态   0：创建  1：待兑换 2：领奖成功 3：领奖失败
    private Long orderId;//主订单ID
    private String ip;//用户IP
    private Date gmtCreate; //创建时间
    private Date gmtModified; //变更时间

    //No column of database
    private String orderNum; //主订单号
    private String partnerUserId;
    private Integer winningNum;

    /**
     * 
     * Creates a new instance of SingleLotteryOrderDto.
     *
     */
    public SingleLotteryOrderDto() {
        super();
    }

    /**
     * 
     * Creates a new instance of SingleLotteryOrderDto.
     *
     * @param init4insert
     */
    public SingleLotteryOrderDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    /**
     * 
     * Creates a new instance of SingleLotteryOrderDto.
     *
     * @param id
     */
    public SingleLotteryOrderDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     * 
     * generateOrderNum:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public static synchronized String generateOrderNum(Long id) {
        return PREFIX_ORDER + id.toString();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getCredits() {
        return credits;
    }

    public Integer getOptionType() {
        return optionType;
    }

    public void setOptionType(Integer optionType) {
        this.optionType = optionType;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public Integer getPrizeFacePrice() {
        return prizeFacePrice;
    }

    public void setPrizeFacePrice(Integer prizeFacePrice) {
        this.prizeFacePrice = prizeFacePrice;
    }

    public String getPrizeDegree() {
        return prizeDegree;
    }

    public void setPrizeDegree(String prizeDegree) {
        this.prizeDegree = prizeDegree;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getError4admin() {
        return error4admin;
    }

    public void setError4admin(String error4admin) {
        if(error4admin!=null&&error4admin.length()>200){
            error4admin = error4admin.substring(0,200);
        }
        this.error4admin = error4admin;
    }

    public String getError4developer() {
        return error4developer;
    }

    public void setError4developer(String error4developer) {
        if(error4developer!=null&&error4developer.length()>200){
            error4developer = error4developer.substring(0,200);
        }
        this.error4developer = error4developer;
    }

    public String getError4consumer() {
        return error4consumer;
    }

    public void setError4consumer(String error4consumer) {
        if(error4consumer!=null&&error4consumer.length()>200){
            error4consumer = error4consumer.substring(0,200);
        }
        this.error4consumer = error4consumer;
    }

    public Integer getExchangeStatus() {
        return exchangeStatus;
    }

    public void setExchangeStatus(Integer exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Integer getWinningNum() {
        return winningNum;
    }

    public void setWinningNum(Integer winningNum) {
        this.winningNum = winningNum;
    }
}
