package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.sign.SignLogDto;
import cn.com.duiba.activity.center.api.dto.sign.SignResultDto;
import cn.com.duiba.activity.center.api.enums.SignStatusEnum;
import cn.com.duiba.activity.center.api.params.SignLogQueryParam;
import cn.com.duiba.activity.center.api.params.SignRequestParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 签到流水
 * Created by xiaoxuda on 2017/5/31.
 */
public interface RemoteSignLogService {

    /**
     * 查询签到流水
     * @param logId
     * @return
     */
    DubboResult<SignLogDto> findByLogId(Long logId);

    /**
     * 签到请求
     * 如果已存在当天的签到记录
     * 1.状态为失败则允许重试，创建新的签到流水
     * 2.状态不是失败，则返回签到失败结果，包含签到信息的当前状态
     * @param param
     * @return
     */
    DubboResult<SignResultDto> createSignLog(SignRequestParam param);

    /**
     * 更新签到状态,已达到终态的记录不可变更状态，返回失败结果
     * 签到成功时更新签到统计表tb_sign_statics
     * @param logId
     * @param signStatus
     * @return
     */
    DubboResult<Boolean> updateSignLogStatus(Long logId, SignStatusEnum signStatus);

    /**
     * 根据时间间隔查询签到记录
     * @param param
     * @return
     */
    DubboResult<List<SignLogDto>> findByDateInterval(SignLogQueryParam param);
}
