package cn.com.duiba.activity.center.api.dto.creditgame;

import java.io.Serializable;

/**
 * Created by Ansoya on 2016/11/11.
 */
public class DeveloperConsumeFailedExceptionDto extends Exception implements Serializable{

    private static final long serialVersionUID = -3452319566458382726L;
    private final String code;
    private final Boolean normalFail;//是否正常的消费积分失败  true正常的开发者返回失败，fasle服务器异常。
    private final String url;
    private final String devRespone;
    private final Integer failType;
    private final Integer interfaceType;

    public static final int FailTypeDefault = 1; // 其他
    public static final int FailTypebizId = 2; // 订单号重复
    public static final int FailTypeJson = 3; // json
    public static final int ConsumerCreditsType = 1;//用户积分扣除接口


    /**
     * 构造器
     */
    public DeveloperConsumeFailedExceptionDto() {
           this.code = null;
           this.normalFail = null;
           this.url = null;
           this.devRespone = null;
           this.failType = null;
           this.interfaceType = null;
       }


    /**
     * Creates a new instance of DeveloperConsumeFailedException.
     * @param code
     * @param msg
     * @param normalFail
     * @param url
     * @param devResponse
     * @param failType
     * @param interfaceType
     * @param throwable
     */
    public DeveloperConsumeFailedExceptionDto(String code,String msg,Boolean normalFail,
                                           String url,String devResponse,
                                           Integer failType,Integer interfaceType,Throwable throwable) {
        super(msg, throwable);
        this.code = code;
        this.normalFail = normalFail;
        this.url = url;
        this.devRespone = devResponse;
        this.failType = failType;
        this.interfaceType = interfaceType;
    }

    /**
     * DeveloperConsumeFailedExceptionDto
     * @param msg
     * @param normalFail
     * @param failType
     */
    public DeveloperConsumeFailedExceptionDto(String msg,Boolean normalFail,Integer failType) {
        super(msg);
        this.code = null;
        this.normalFail = normalFail;
        this.url = null;
        this.devRespone = null;
        this.failType = failType;
        this.interfaceType = null;
    }

    /**
     * DeveloperConsumeFailedExceptionDto
     * @param msg
     * @param normalFail
     * @param failType
     * @param throwable
     */
    public DeveloperConsumeFailedExceptionDto(String msg,Boolean normalFail,Integer failType,Throwable throwable) {
        super(msg,throwable);
        this.code = null;
        this.normalFail = normalFail;
        this.url = null;
        this.devRespone = null;
        this.failType = failType;
        this.interfaceType = null;
    }

    /**
     * DeveloperConsumeFailedExceptionDto
     * @param code
     * @param msg
     */
    public DeveloperConsumeFailedExceptionDto(String code,String msg) {
        super(msg);
        this.code = code;
        this.normalFail = null;
        this.url = null;
        this.devRespone = null;
        this.failType = null;
        this.interfaceType = null;
    }

    /**
     * DeveloperConsumeFailedExceptionDto
     * @param msg
     * @param normalFail
     */
    public DeveloperConsumeFailedExceptionDto(String msg,Boolean normalFail) {
        super(msg);
        this.code = null;
        this.normalFail = normalFail;
        this.url = null;
        this.devRespone = null;
        this.failType = FailTypeDefault;
        this.interfaceType = null;
    }

    /**
     * DeveloperConsumeFailedExceptionDto
     * @param throwable
     */
    public DeveloperConsumeFailedExceptionDto(Throwable throwable) {
        super(throwable);
        this.code = null;
        this.normalFail = null;
        this.url = null;
        this.devRespone = null;
        this.failType = null;
        this.interfaceType = null;
    }

    public String getCode() {
        return this.code;
    }

    public Boolean getNormalFail() {
        return normalFail;
    }


    public String getUrl() {
        return url;
    }

    public String getDevRespone() {
        return devRespone;
    }

    public Integer getFailType() {
        return failType;
    }

    public Integer getInterfaceType() {
        return interfaceType;
    }

}
