package cn.com.duiba.activity.center.api.dto.hdtool;

import cn.com.duiba.dcommons.enums.ItemTypeEnums;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动订单表
 * 
 * @author houwen
 */
public class HdtoolOrdersDto implements Serializable {
	private static final long serialVersionUID = -7560015999674302687L;

	public static final String PREFIX_ORDER = "hdtool-";

	public static final String PrizeTypeVirtual = ItemTypeEnums.TypeVirtual.getName();       //虚拟商品
	public static final String PrizeTypeAlipay = ItemTypeEnums.TypeAlipay.getName(); 		// 支付宝
	public static final String PrizeTypeQB = ItemTypeEnums.TypeQB.getName();					// QB
	public static final String PrizeTypeCoupon = ItemTypeEnums.TypeCoupon.getName();			// 优惠劵
	public static final String PrizeTypeObject = ItemTypeEnums.TypeObject.getName();			// 实物
	public static final String PrizeTypePhonebill = ItemTypeEnums.TypePhonebill.getName();	// 话费
	public static final String PrizeTypeThanks = "thanks";					// 谢谢参与
	public static final String PrizeTypeAgain = "again"; 					// 再来一次
	public static final String PrizeTypeLuckBag = "lucky";                // 福袋

	public static final int ExchangeStatusCreate = 0;	// 创建
	public static final int ExchangeStatusWait = 1;		// 待领取
	public static final int ExchangeStatusSuccess = 2; 	// 领奖成功
	public static final int ExchangeStatusFail = 3;		// 领奖失败，可以再次尝试
	public static final int ExchangeStatusOverdue = 4;	// 未领取，过期

	public static final int StatusCreate = 0; 		// 处理中
	public static final int StatusSuccess = 1;		// 处理成功
	public static final int StatusFail = 2;			// 处理失败

	private Long id;
	private Integer status;
	private Long appId;
	private Long consumerId;
	private String partnerUserId;
	private Long operatingActivityId;
	private Long duibaHdtoolId;
	private Integer hdtoolType;
	private Long prizeId;
	private String prizeName;
	private Long appItemId;
	private Long itemId;
	private Long couponId;
	private String facePrice;
	private Long credits;
	private String prizeType;
	private Integer exchangeStatus;
	private Long sourceOrderId;
	private Long mainOrderId;
	private String mainOrderNum;
	private String developerBizId;
	private String error4Admin;
	private String error4Developer;
	private String error4Consumer;
	private String ip;
	private Date gmtCreate;
	private Date gmtModified;

	//当虚拟商品需要用户输入账号的时候，用于临时存储用户输入的用户名
	private String username;

	/**
	 * 
	 * Creates a new instance of HdtoolOrdersDto.
	 *
	 */
	public HdtoolOrdersDto() {
		super();
	}

	/**
	 * 
	 * Creates a new instance of HdtoolOrdersDto.
	 *
	 * @param id
	 */
	public HdtoolOrdersDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 
	 * Creates a new instance of HdtoolOrdersDto.
	 *
	 * @param init4insert
	 */
	public HdtoolOrdersDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	/**
	 * 
	 * generateOrderNum:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public static synchronized String generateOrderNum(Long id) {
		return PREFIX_ORDER + id.toString();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}

	public Long getDuibaHdtoolId() {
		return duibaHdtoolId;
	}

	public void setDuibaHdtoolId(Long duibaHdtoolId) {
		this.duibaHdtoolId = duibaHdtoolId;
	}

	public Integer getHdtoolType() {
		return hdtoolType;
	}

	public void setHdtoolType(Integer hdtoolType) {
		this.hdtoolType = hdtoolType;
	}

	public Long getPrizeId() {
		return prizeId;
	}

	public void setPrizeId(Long prizeId) {
		this.prizeId = prizeId;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public String getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(String facePrice) {
		this.facePrice = facePrice;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public Integer getExchangeStatus() {
		return exchangeStatus;
	}

	public void setExchangeStatus(Integer exchangeStatus) {
		this.exchangeStatus = exchangeStatus;
	}

	public Long getSourceOrderId() {
		return sourceOrderId;
	}

	public void setSourceOrderId(Long sourceOrderId) {
		this.sourceOrderId = sourceOrderId;
	}

	public Long getMainOrderId() {
		return mainOrderId;
	}

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public String getMainOrderNum() {
		return mainOrderNum;
	}

	public void setMainOrderNum(String mainOrderNum) {
		this.mainOrderNum = mainOrderNum;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}
	
	public String getError4Admin() {
		return error4Admin;
	}

	public void setError4Admin(String error4Admin) {
		if(error4Admin!=null&&error4Admin.length()>250){
			error4Admin = error4Admin.substring(0,250);
		}
		this.error4Admin = error4Admin;
	}

	public String getError4Developer() {
		return error4Developer;
	}

	public void setError4Developer(String error4Developer) {
		if(error4Developer!=null&&error4Developer.length()>250){
			error4Developer = error4Developer.substring(0,250);
		}
		this.error4Developer = error4Developer;
	}

	public String getError4Consumer() {
		return error4Consumer;
	}

	public void setError4Consumer(String error4Consumer) {
		if(error4Consumer!=null&&error4Consumer.length()>250){
			error4Consumer = error4Consumer.substring(0,250);
		}
		this.error4Consumer = error4Consumer;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

}
