package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.SignSourceTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignStatusEnum;
import cn.com.duiba.activity.center.api.enums.SignTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by liuyao on 2016/12/21.
 * 签到日志表
 */
public class SignLogDto extends BaseDto implements Serializable{

    public static final long serialVersionUID = 1053047858801268831L;

    private Long id;
    /**
     * 签到流水号
     */
    private Long logId;
    /**
     * 开发者业务号（来至开发者可为空）
     */
    private String bizId;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * 签到数据来源
     */
    private SignSourceTypeEnum sourceType;
    /**
     * 签到来源关联ID
     */
    private Long sourceRelationId;
    /**
     * 本次签到所加积分
     */
    private Integer credits;
    /**
     * 本次签到所加活动次数
     */
    private Integer activityCount;
    /**
     * 签到类型
     */
    private SignTypeEnum signType;
    /**
     * 签到状态
     */
    private SignStatusEnum signStatus = SignStatusEnum.WAIT;

    private Date gmtCreate;
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getLogId() {
        return logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public SignSourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SignSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public SignStatusEnum getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(SignStatusEnum signStatus) {
        this.signStatus = signStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
