/**
 * Project Name:activity-center-api
 * File Name:RemoteOperatingHdtoolNewService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.activity
 * Date:2016年11月18日下午4:42:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.activity;

import java.util.List;

import org.javatuples.Pair;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOptionsDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteOperatingHdtoolNewService <br/>
 * Date:     2016年11月18日 下午4:42:28 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteOperatingHdtoolNewService {

    /**
     * 
     * hdtoolIndexValid:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexValid(Long operatingActivityId,Long appId);
    
    /**
     * 
     * findHdtoolOptions:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityDO
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<HdtoolOptionsDto>> findHdtoolOptions(OperatingActivityDto operatingActivityDO);
    
    /**
     * 
     * getLimitCountNum:(这里用一句话描述这个方法的作用). <br/>
     * 获取用户抽奖次数
     * @param consumerId
     * @param operatingActivityDO
     * @param duibaHdtool
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> getLimitCountNum(Long consumerId, OperatingActivityDto operatingActivityDO,DuibaHdtoolDto duibaHdtool);

    /**
     * 
     * getFreeLimitNum:(这里用一句话描述这个方法的作用). <br/>
     * 获取用户免费抽奖次数
     * @param consumerId
     * @param operatingActivityDO
     * @param duibaHdtool
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> getFreeLimitNum(Long consumerId, OperatingActivityDto operatingActivityDO,DuibaHdtoolDto duibaHdtool);

    /**
     * 
     * 根据id 和type 查询 活动信息. <br/>
     * 
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Pair<OperatingActivityDto, DuibaHdtoolDto>> hdtoolIndexValid(Long operatingActivityId);
}

