package cn.com.duiba.activity.center.api.remoteservice.seconds_kill;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityAppSpecifyDto;

/**
 * 
 * ClassName: RemoteDuibaSecondsKillActivityAppSpecifyService <br/>
 * date: 2016年12月1日 下午5:35:33 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaSecondsKillActivityAppSpecifyService {

    /**
     * 
     * findByDuibaActivityAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 根据duibaActivityId 和 appId来查询定向关系
     * @param duibaSecondsKillActivityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
	public DuibaSecondsKillActivityAppSpecifyDto findByDuibaActivityAndApp(Long duibaSecondsKillActivityId, Long appId);

	/**
	 * 
	 * findByDuibaSecondsKillActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSecondsKillActivityId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSecondsKillActivityAppSpecifyDto> findByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId);
	
	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaSecondsKillActivityAppSpecify
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSecondsKillActivityAppSpecifyDto insert(DuibaSecondsKillActivityAppSpecifyDto duibaSecondsKillActivityAppSpecify);

	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	public void delete(Long id);
	
	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSecondsKillActivityAppSpecifyDto find(Long id);
	
	/**
	 * 
	 * findByDuibaSecondsKillActivityAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * 根据duibaSecondsKillActivityId 和 appId来查询定向关系
	 * @param duibaSecondsKillActivityId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSecondsKillActivityAppSpecifyDto findByDuibaSecondsKillActivityAndApp(Long duibaSecondsKillActivityId, Long appId);
	
	/**
	 * 
	 * findByDuibaActivityIdsAndApp:(这里用一句话描述这个方法的作用). <br/>
	 * @param activityIds
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSecondsKillActivityAppSpecifyDto> findByDuibaActivityIdsAndApp(List<Long> activityIds, Long appId);
	
}
