/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.dto.sign.SignRuleConfigDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRuleItemDto;
import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import cn.com.duiba.activity.center.api.exception.ActivityCenterRuntimeException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public enum SignTypeEnum {
    CONTINUE(0, "\u8fde\u7eed\u7b7e\u5230"){

        @Override
        public SignRuleItemDto getRuleItemSub(int continueDay, int dayFeature, SignRuleConfigDto signRuleConfig) {
            int circle = signRuleConfig.getItems().size();
            int index = (continueDay += dayFeature) > circle ? circle : continueDay;
            return signRuleConfig.getItems().get(index - 1);
        }
    }
    ,
    CIRCLE(1, "\u5468\u671f\u7b7e\u5230"){

        @Override
        public SignRuleItemDto getRuleItemSub(int continueDay, int dayFeature, SignRuleConfigDto signRuleConfig) {
            int circle = signRuleConfig.getItems().size();
            int index = (continueDay += dayFeature) % circle;
            index = index == 0 ? circle : index;
            return signRuleConfig.getItems().get(index - 1);
        }
    }
    ,
    CUSTOM(2, "\u81ea\u5b9a\u4e49\u7b7e\u5230"){

        @Override
        public SignRuleItemDto getRuleItemSub(int continueDay, int dayFeature, SignRuleConfigDto signRuleConfig) {
            return null;
        }
    }
    ,
    MONTH(3, "\u81ea\u7136\u6708\u7b7e\u5230"){

        @Override
        public SignRuleItemDto getRuleItemSub(int continueDay, int dayFeature, SignRuleConfigDto signRuleConfig) {
            Calendar signCal = Calendar.getInstance();
            signCal.set(5, signCal.get(5) + (dayFeature - 1));
            int daysInMonth = signCal.getActualMaximum(5);
            int daysOfMonth = signCal.get(5);
            if (daysOfMonth == daysInMonth && (continueDay += dayFeature) >= daysInMonth && signRuleConfig.getItems().size() == 2) {
                return signRuleConfig.getItems().get(1);
            }
            if (continueDay > daysOfMonth) {
                continueDay = daysOfMonth;
            }
            SignRuleItemDto item = signRuleConfig.getItems().get(0);
            SignRuleItemDto itemResult = (SignRuleItemDto)BeanUtils.copy((Object)item, SignRuleItemDto.class);
            itemResult.setCredits(itemResult.getCredits() + (continueDay - 1) * signRuleConfig.getIncr());
            return itemResult;
        }
    };

    private static Map<Integer, SignTypeEnum> typeEnumMap;
    private Integer code;
    private String desc;

    public static SignTypeEnum getByCode(int code) {
        SignTypeEnum type = typeEnumMap.get(code);
        if (type == null) {
            throw new ActivityCenterRuntimeException("\u4e0d\u652f\u6301\u7684\u7b7e\u5230\u7c7b\u578b");
        }
        return type;
    }

    private SignTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    protected abstract SignRuleItemDto getRuleItemSub(int var1, int var2, SignRuleConfigDto var3);

    public SignRuleItemDto getRuleItem(Integer continueDay, Date signDate, SignRuleConfigDto signRuleConfig) {
        int dayFeature;
        if (signDate == null || (dayFeature = DateUtils.daysBetween((Date)new Date(), (Date)signDate)) < 0) {
            throw new ActivityCenterException("\u76ee\u6807\u7b7e\u5230\u65e5\u671f\u975e\u6cd5");
        }
        return this.getRuleItemSub(continueDay, dayFeature + 1, signRuleConfig);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        typeEnumMap = new HashMap<Integer, SignTypeEnum>();
        for (SignTypeEnum typeEnum : SignTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }
}

