package cn.com.duiba.activity.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/** 
 * ClassName:ActivityDataTypeEnum.java <br/>
 * @author  gey 
 * @date 创建时间：2017年7月19日 下午4:18:59 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
public enum ActivityDataTypeEnum {
	
	ACTIVITY_TOOL("hdtool","概率出奖",false),
	QUESTION_ANSWER("question","答题活动",true);
	
	//后续操作key
	private String key;
	//名称
	private String name;
	//是否执行 后续操作  true 不执行，false 执行
	private boolean executeFlag;
	private static Map<String,ActivityDataTypeEnum> typeMap = Maps.newHashMap();
	
	ActivityDataTypeEnum(String key,String name,boolean executeFlag){
		this.name = name;
		this.key = key;
		this.executeFlag = executeFlag;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public boolean isExecuteFlag() {
		return executeFlag;
	}

	public void setExecuteFlag(boolean executeFlag) {
		this.executeFlag = executeFlag;
	}

	static{
		for(ActivityDataTypeEnum typeClass : ActivityDataTypeEnum.values()){
			typeMap.put(typeClass.getKey(),typeClass);
		}
	}

	/**
	 * 根据type获取具体枚举类型
	 * @param type
	 * @return
	 */
	public static ActivityDataTypeEnum getByType(String key){
		return typeMap.get(key);
	}
}
