/**
 * Project Name:activity-center-api
 * File Name:RemoteAdActivityService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.advertising
 * Date:2016年9月30日下午5:03:56
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.advertising;

import cn.com.duiba.activity.center.api.dto.advertising.AdActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Map;

/**
 * ClassName:RemoteAdActivityService <br/>
 * Date:     2016年9月30日 下午5:03:56 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAdActivityService {
    /**
     * 获取指定活动ID的广告详细信息
     * @deprecated
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return DuibaAdActivityDto 
     */
    @Deprecated
    DubboResult<AdActivityDto> queryByActivityId(Long activityId,Integer activityType);
    /**
     * 投放广告时上架活动
     * @deprecated
     * @param appKey app唯一标识
     * @param activityId 活动ID
     * @param activityType 活动类型(OperatingActivityDto 中的常量定义)
     * @return operatingActivityId，活动打开url
     */
    @Deprecated
    DubboResult<AdActivityDto> addOnApp(Long activityId,Integer activityType,String appKey);
    
    /**
     * queryAndAddOnApp:获取活动信息，同时上架活动. <br/>
     * 老的活动直达页跳老的活动页
     * @param activityId
     * @param activityType
     * @param appKey
     * @return
     * @deprecated
     */
    @Deprecated
    DubboResult<AdActivityDto> queryAndAddOnApp(Long activityId,Integer activityType,String appKey);
    
    /**
     * 
     * queryAndAddOnApp<br/>
     * (此链接有app白名单，需要app加入到白名单方可打开)
     * 新的活动直达页跳新的活动页
     * @author wubo
     * @param activityId
     * @param activityType
     * @param appKey
     * @param attachments 附带参数(会拼进返回的url里)
     * @return
     * @since JDK 1.6
     */
    DubboResult<AdActivityDto> queryAndAddOnApp(Long activityId,Integer activityType,String appKey,Map<String,String> attachments);
    
    /**
     * 
     * queryAndAddOnApp2 <br/>
     * 
     * 老的活动直达页跳新的活动页
     * 缺点：跳到最终的活动页需要重定向4次
     * @author wubo
     * @param activityId
     * @param activityType
     * @param appKey
     * @param attachments
     * @return
     * @since JDK 1.6
     */
    DubboResult<AdActivityDto> queryAndAddOnApp2(Long activityId,Integer activityType,String appKey,Map<String,String> attachments);
    
    /**
     * 活动中心，广告活动上架
     * addOnAppForDuiba. <br/>
     *
     * @param activityId
     * @param activityType
     * @param appId
     * @return
     */
    DubboResult<AdActivityDto> addOnAppForDuiba(Long activityId,Integer activityType,Long appId);
}

