/**
 * Project Name:activity-center-api File Name:RemoteGameCenterBackendService.java Package
 * Name:cn.com.duiba.activity.center.api.remoteservice.gamecenter Date:2016年10月18日下午8:21:04 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.api.remoteservice.gamecenter;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterStatisticDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameCenterBackendService <br/>
 * Function: 游戏中心后台服务. <br/>
 * Date: 2016年10月18日 下午8:21:04 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface RemoteGameCenterBackendService {

    /**
     * findStatistic:管理端：查询游戏中心统计数据：小游戏数量，各个区域小游戏或活动数量. <br/>
     * 
     * @author zhuzhiyong
     * @return the dubbo result
     * @since JDK 1.6
     */
    DubboResult<GameCenterStatisticDto> findStatistic();

    /**
     * findLittleGameResource:管理端：查询小游戏列表. <br/>
     *
     * @author zhuzhiyong
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<LittleGameResourceListDto> findLittleGameResource(Integer offset, Integer max);

    /**
     * updateResourceLocation:管理端：更新小游戏展示位. <br/>
     * 支持增删改，传递最终结果即可.<br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @param addLocationNames the add location names
     * @param delLocationNames the del location names
     * @return the dubbo result
     */
    DubboResult<Boolean> updateResourceLocation(Long activityId, Integer activityType, List<String> addLocationNames,
                                                List<String> delLocationNames);

    /**
     * findRelatedActivity:管理端：查询关联的活动列表. <br/>
     *
     * @author zhuzhiyong
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<RelatedActivityListDto> findRelatedActivity(Integer offset, Integer max);

    /**
     * addRelatedActivity:管理端：关联活动. <br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @return the dubbo result
     */
    DubboResult<Boolean> addRelatedActivity(Long activityId, Integer activityType);

    /**
     * deleteRelatedActivity:管理端：取消关联活动. <br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @return the dubbo result
     */
    DubboResult<Boolean> deleteRelatedActivity(Long activityId, Integer activityType);

    /**
     * findAvailableLittleGameByAppId:开发者端：查询展示的小游戏列表. <br/>
     * 过滤掉屏蔽记录.<br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<LittleGameResourceListDto> findAvailableLittleGameByAppId(Long appId, Integer offset, Integer max);

    /**
     * findHiddenLittleGameByAppId:开发者端：查询开发者屏蔽的小游戏列表. <br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<LittleGameResourceListDto> findHiddenLittleGameByAppId(Long appId, Integer offset, Integer max);
}
