package cn.com.duiba.activity.center.api.remoteservice.guess;


import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessStockDto;

import java.util.List;

/**
 * 
 * ClassName: RemoteDuibaGuessStockService <br/>
 * date: 2016年12月1日 下午3:07:45 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public interface RemoteDuibaGuessStockService {

    /**
     * 
     * findRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param relationId
     * @return
     * @since JDK 1.6
     */
	public DuibaGuessStockDto findRemaining(Long relationId);
	
	/**
	 * 
	 * subStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param subNumber
	 * @return
	 * @since JDK 1.6
	 */
	public int subStock(Long id, Integer subNumber);
	
	/**
	 * 
	 * addStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param addNumber
	 * @return
	 * @since JDK 1.6
	 */
	public int addStock(Long id, Integer addNumber);

	//from manager

	/**
	 * 
	 * findByGuessOptionId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param guessOptionId
	 * @return
	 * @since JDK 1.6
	 */
	DuibaGuessStockDto findByGuessOptionId(Long guessOptionId);

	/**
	 * 
	 * findByGuessOptionIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	List<DuibaGuessStockDto> findByGuessOptionIds(List<Long> list);

	/**
	 * 增加库存
	 * @param id
	 * @param stockAdd
	 * @return
	 */
	int updateStockAdd(Long id, Integer stockAdd);
	/**
	 * 减少库存
	 * @param id
	 * @param stockSub
	 * @return
	 */
	int updateStockSub(Long id, Integer stockSub);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param guessStockDO
	 * @return
	 * @since JDK 1.6
	 */
	DuibaGuessStockDto add(DuibaGuessStockDto guessStockDO);

	/**
	 * 
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @since JDK 1.6
	 */
	void addBatch(List<DuibaGuessStockDto> list);
}
