package cn.com.duiba.activity.center.api.remoteservice.guess;

import cn.com.duiba.activity.center.api.dto.guess.GuessOrdersDto;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
public interface RemoteGuessOrdersConsumerService {
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param guessOrderId
     * @return
     * @since JDK 1.6
     */
    public GuessOrdersDto find(Long consumerId , Long guessOrderId);

    /**
     * 
     * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

    /**
     * 
     * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param operatingActivityId
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param id
     * @param start
     * @param end
     * @return
     * @since JDK 1.6
     */
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long id, Date start, Date end);

    /**
     * 
     * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long id);

    /**
     * 
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findByIds(Long consumerId, List<Long> ids);

    /**
     * 
     * findWinOrders:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param duibaGuessId
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findWinOrders(Long consumerId, Long duibaGuessId);

    /**
     * 
     * findGuessOrders:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param duibaGuessId
     * @return
     * @since JDK 1.6
     */
    public List<GuessOrdersDto> findGuessOrders(Long consumerId, Long duibaGuessId);

    /**
     * 
     * updateStatusToSuccess:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param guessOrderId
     * @param guessOrderExtraId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusToSuccess(Long consumerId,Long guessOrderId, Long guessOrderExtraId);

    /**
     * 
     * updateStatusToFail:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param guessOrderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    public int updateStatusToFail(Long consumerId,Long guessOrderId, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * updateExchangeStatusToWaitOpen:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param guessOrderId
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToWaitOpen(Long consumerId,Long guessOrderId);

    /**
     * 
     * updateExchangeStatusToWaitOpenAndExtraId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param guessOrderId
     * @param guessOrderExtraId
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId,Long guessOrderId, Long guessOrderExtraId);

    /**
     * 
     * updateExchangeStatusToWait:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @param itemId
     * @param appItemId
     * @param prizeId
     * @param prizeType
     * @param prizeName
     * @param prizeFacePrice
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToWait(Long consumerId,Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);

    /**
     * 
     * updateExchangeStatusToFail:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToFail(Long consumerId,Long gameOrderId, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * doTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @return
     * @since JDK 1.6
     */
    public int doTakePrize(Long consumerId,Long gameOrderId);

    /**
     * 
     * rollbackTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @return
     * @since JDK 1.6
     */
    public int rollbackTakePrize(Long consumerId,Long gameOrderId);

    /**
     * 
     * updateManualOpenPrizeExchangeStatusToWait:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @param itemId
     * @param appItemId
     * @param prizeId
     * @param prizeType
     * @param prizeName
     * @param prizeFacePrice
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId,Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId);

    /**
     * 
     * updateIsGivePrize:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param id
     * @param b
     * @return
     * @since JDK 1.6
     */
    public int updateIsGivePrize(Long consumerId, Long id, int b);
    
    /**
     * 
     * updateExchangeStatusToOverdue:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单领奖状态为过期失效
     * @param consumerId
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToOverdue(Long consumerId,long id, String error4admin, String error4developer, String error4consumer) ;

    /**
     * 
     * updateStatusToConsumeSuccess:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @return
     * @since JDK 1.6
     */
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId);

    /**
     * 
     * updateExchangeStatusToWaitOpenAndExtraIdForLuck:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param gameOrderId
     * @param guessOrderExtraId
     * @return
     * @since JDK 1.6
     */
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long guessOrderExtraId);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 添加竞猜订单
     * @param guessOrdersDto
     * @return
     * @since JDK 1.6
     */
    public GuessOrdersDto insert(GuessOrdersDto guessOrdersDto);

    /**
     * 
     * updateDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param id
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    public int updateDeveloperBizId(Long consumerId,long id, String bizId);

    /**
     * 
     * updateMainOrderId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param consumerId
     * @param id
     * @param mainOrderId
     * @param mainOrderNum
     * @return
     * @since JDK 1.6
     */
    public int updateMainOrderId(Long consumerId,long id, Long mainOrderId, String mainOrderNum);

}
