package cn.com.duiba.activity.center.api.remoteservice.plugin;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.flow.FlowFeatureDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginVistDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteActivityPluginService.java <br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2016年10月13日 下午4:09:53
 * @parameter
 * @since JDK 1.6
 */
public interface RemoteActivityPluginService {

    /**
     * findActivityPluginInfoList:(这里用一句话描述这个方法的作用). <br/>
     * 查询插件活动list
     *
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList();

    /**
     * findBrickById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询签到皮肤
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<PopupActivityBrickDto> findBrickById(Long id);

    /**
     * findBrickById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询签到皮肤
     *
     * @param ids
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long,PopupActivityBrickDto>> findBrickByIds(List<Long> ids);

    /**
     * findById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询插件活动
     *
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<ActivityPluginDto> findById(Long id);

    /**
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id开启插件活动配置
     *
     * @param id
     * @param value
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateStatus(Long id, Integer value);

    /**
     * 编辑插件活动配置
     */
    DubboResult<Integer> updateActivityPluginInfo(Long id, Integer activityType);

    /**
     * 根据Id查询插件活动
     *
     * @return 操作结果
     */
    DubboResult<ActivityPluginVistDto> findByActivityIdAndType(Long id, Integer activityType);

    /**
     * 根据流量规则获取插件列表
     *
     * @param dto
     * @return
     */
    DubboResult<List<ActivityPluginDto>> findByFlowRule(FlowFeatureDto dto);

}