package cn.com.duiba.activity.center.api.dto;

import cn.com.duiba.activity.center.api.enums.ActivityStatusEnum;
import cn.com.duiba.activity.center.api.enums.ActivityTypeEnum;

/**
 * 兑吧活动信息
 * Created by xiaoxuda on 2017/1/22.
 */
public class ActivityCommonDto extends BaseDto {

    private static final long serialVersionUID = 5429463881176654060L;

    public static final Integer SWITCHES_APP_DIRECT = 0; // 定向发放
    public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品

    private Long activityId;//兑吧活动Id
    private ActivityTypeEnum type;//活动类型
    private Boolean delete;//活动是否删除
    private ActivityStatusEnum status;//活动展示状态
    private String title;//活动名称
    private String description;//活动描述
    //位运算标识
    private Integer switches;
    /**
     * 缩略图
     */
    private String thumb;
    /**
     * 白底缩略图,部分活动没有
     */
    private String whitethumb;
    /**
     * banner图
     */
    private String banner;
    /**
     * logo图
     */
    private String logo;
    /**
     * 推荐图,部分活动没有
     */
    private String recommendImage;
    /**
     * 兑换所需积分
     */
    private Long credits;

    /**
     * 市场价，主要用于秒杀活动
     */
    private Integer marketPrice;

    /**
     * 开关判断
     * @param bit 开关位
     * @return
     */
    public boolean isOpen(int bit){
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public ActivityTypeEnum getType() {
        return type;
    }

    public void setType(ActivityTypeEnum type) {
        this.type = type;
    }

    public Boolean getDelete() {
        return delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public ActivityStatusEnum getStatus() {
        return status;
    }

    public void setStatus(ActivityStatusEnum status) {
        this.status = status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public String getThumb() {
        return thumb;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    public String getWhitethumb() {
        return whitethumb;
    }

    public void setWhitethumb(String whitethumb) {
        this.whitethumb = whitethumb;
    }

    public String getBanner() {
        return banner;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getRecommendImage() {
        return recommendImage;
    }

    public void setRecommendImage(String recommendImage) {
        this.recommendImage = recommendImage;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getMarketPrice() {
        return marketPrice;
    }

    public void setMarketPrice(Integer marketPrice) {
        this.marketPrice = marketPrice;
    }
}
