package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterRuntimeException;

import java.util.HashMap;
import java.util.Map;

/**
 * 签到数据来源
 * Created by xiaoxuda on 2017/5/31.
 */
public enum SignSourceTypeEnum {
    UNIFORM(1, "统一签到"),
    SIGN_SYSTEM(2, "签到体系签到");

    private static Map<Integer, SignSourceTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (SignSourceTypeEnum typeEnum : SignSourceTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到来源类型
     *
     * @param code
     * @return
     */
    public static SignSourceTypeEnum getByCode(int code) {
        SignSourceTypeEnum type = typeEnumMap.get(code);
        if(type == null){
            throw new ActivityCenterRuntimeException("不支持的签到来源");
        }
        return type;
    }

    SignSourceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
