package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * hdtool_orders表的consumer维度分表,活动工具订单业务DAO
 */
public interface RemoteCreditsHdtoolOrdersService {

	//from NewHdtoolOrderSimpleDAO in credits

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询订单
     * @param consumerId
     * @param id
     * @return
     * @since JDK 1.6
     */
	HdtoolOrdersDto find(Long consumerId, Long id);

	/**
	 * 
	 * countByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * 查询用户参与活动次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

	/**
	 * 
	 * countByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * 查询用户在时间段内参与活动次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
	 * 查询用户免费参与活动次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId);

	/**
	 * 
	 * countFreeByConsumerIdAndOperatingActivityIdAndDate:(这里用一句话描述这个方法的作用). <br/>
	 * 查询用户在时间段内免费参与活动次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @param start
	 * @param end
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end);

	/**
	 * 
	 * countByConsumerIdAndPrizeId:(这里用一句话描述这个方法的作用). <br/>
	 * 查询用户中奖某奖项次数
	 * @param consumerId
	 * @param operatingActivityId
	 * @param prizeId
	 * @return
	 * @since JDK 1.6
	 */
	public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId);

	/**
	 * 
	 * findByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动订单ID集合查询订单信息
	 * @param consumerId
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	List<HdtoolOrdersDto> findByIds(Long consumerId, List<Long> ids);

	/**
	 * 
	 * findByAppAndDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
	 * 根据开发者订单号查询订单
	 * @param consumerId
	 * @param appId
	 * @param bizId
	 * @return
	 * @since JDK 1.6
	 */
	HdtoolOrdersDto findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId);

	/**
	 * 
	 * findExpireOrder:(这里用一句话描述这个方法的作用). <br/>
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 * @return
	 * @since JDK 1.6
	 */
	List<Long> findExpireOrder();

	//from NewHdtoolOrderStatusChangeDAO in credits

	/**
	 * 
	 * updateExchangeStatusToFail:(这里用一句话描述这个方法的作用). <br/>
	 * 修改订单领奖状态为失败
	 * @param consumerId
	 * @param id
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

	/**
	 * 
	 * updateExchangeStatusToOverdue:(这里用一句话描述这个方法的作用). <br/>
	 * 修改订单领奖状态为过期失效
	 * @param consumerId
	 * @param id
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

	/**
	 * 
	 * updateStatusToFail:(这里用一句话描述这个方法的作用). <br/>
	 * 修改订单状态失败
	 * @param consumerId
	 * @param id
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @since JDK 1.6
	 */
	int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer);

	/**
	 * 
	 * doTakePrize:(这里用一句话描述这个方法的作用). <br/>
	 * 处理领奖
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	Integer doTakePrize(Long consumerId, Long id);

	/**
	 * 
	 * rollbackTakePrize:(这里用一句话描述这个方法的作用). <br/>
	 * 领奖创建订单失败，回滚领奖
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	Integer rollbackTakePrize(Long consumerId, Long id);

	/**
	 * 
	 * updateLotteryResult:(这里用一句话描述这个方法的作用). <br/>
	 * 处理抽奖结果
	 * @param consumerId
	 * @param id
	 * @param appItemId
	 * @param itemId
	 * @param prizeId
	 * @param prizeName
	 * @param prizeType
	 * @param prizeFacePrice
	 * @param couponId
	 * @return
	 * @since JDK 1.6
	 */
	Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId);

	/**
	 * 
	 * updateLotteryLuckyResult:(这里用一句话描述这个方法的作用). <br/>
	 * 福袋中奖降级处理为谢谢参与
	 * @param consumerId
	 * @param id
	 * @param appItemId
	 * @param itemId
	 * @param prizeId
	 * @param prizeName
	 * @param prizeType
	 * @param prizeFacePrice
	 * @param couponId
	 * @return
	 * @since JDK 1.6
	 */
	Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId);

	//from NewHdtoolOrderTextChangeDAO in credits

	/**
	 * 
	 * updateDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
	 * 修改开发者订单号
	 * @param consumerId
	 * @param id
	 * @param bizId
	 * @return
	 * @since JDK 1.6
	 */
	int updateDeveloperBizId(Long consumerId, long id, String bizId);

	/**
	 * 
	 * updateMainOrderId:(这里用一句话描述这个方法的作用). <br/>
	 * 修改抽奖订单主订单号
	 * @param consumerId
	 * @param id
	 * @param mainOrderId
	 * @param mainOrderNum
	 * @return
	 * @since JDK 1.6
	 */
	int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 添加活动工具订单
	 * @param hdtoolOrdersDto
	 * @return
	 * @since JDK 1.6
	 */
	HdtoolOrdersDto insert(HdtoolOrdersDto hdtoolOrdersDto);

	/**
	 *
	 * 根据ID查询订单，只支持携带分表信息id的查询
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	DubboResult<HdtoolOrdersDto> find(Long id);

}
