package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.sign.SignLogDto;
import cn.com.duiba.activity.center.api.enums.SignStatusEnum;
import cn.com.duiba.activity.center.api.params.SignLogQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 签到流水
 * Created by xiaoxuda on 2017/5/31.
 */
public interface RemoteSignLogService {
    /**
     * 创建签到流水
     * 已存在对应签到记录且状态不是初始状态的返回失败结果及当前状态
     * @param signLogDto
     * @return 签到流水号
     */
    DubboResult<Long> createSignLog(SignLogDto signLogDto);

    /**
     * 更新签到状态,已达到终态的记录不可变更状态，返回失败结果
     * @param logId
     * @param signStatus
     * @return
     */
    DubboResult<Boolean> updateSignLogStatus(Long logId, SignStatusEnum signStatus);

    /**
     * 根据时间间隔查询签到记录
     * @param param
     * @return
     */
    DubboResult<List<SignLogDto>> findByDateInterval(SignLogQueryParam param);
}
