package cn.com.duiba.activity.center.api.remoteservice.sign;

import cn.com.duiba.activity.center.api.dto.sign.SignStaticsDto;
import cn.com.duiba.activity.center.api.enums.SignSourceTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
public interface RemoteSignStaticsService {
    /**
     * 根据用户ID、签到数据来源、来源关联ID查询签到统计信息
     * @param consumerId
     * @param sourceType NOT NULL
     * @param sourceRelationId DEFAULT NULL
     * @return
     */
    DubboResult<SignStaticsDto> findByConsumerIdAndSourceTypeAndRelationId(long consumerId,
                                                                           SignSourceTypeEnum sourceType,
                                                                          Long sourceRelationId);
}
