package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignActivityDto;
import cn.com.duiba.activity.center.api.enums.SignActivityStatusEnum;
import cn.com.duiba.activity.center.api.enums.SignActivityTypeEnum;
import cn.com.duiba.activity.center.api.params.SignActivityQueryParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/4/21.
 */
public interface RemoteSignActivityService {
    /**
     * 新增签到体系活动，保存成功返回活动ID
     *
     * @param dto
     * @return 活动ID
     */
    DubboResult<Long> insert(SignActivityDto dto);

    /**
     * 删除签到活动
     *
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteSignActivity(long id);

    /**
     * 更新指定ID的签到活动信息，不更新null值
     *
     * @param dto id非空
     * @return
     */
    DubboResult<Integer> updateByIdUnNULL(SignActivityDto dto);

    /**
     * 根据ID查询签到活动
     *
     * @param id
     * @return
     */
    DubboResult<SignActivityDto> find(long id);

    /**
     * 获取给定类型下的一个签到活动
     *
     * @param signType
     * @return
     */
    DubboResult<SignActivityDto> findOneByType(SignActivityTypeEnum signType);

    /**
     * 查询给定app可用的签到活动，根据定向和黑名单做过滤
     *
     * @param appId       非空
     * @param developerId 非空
     * @return
     */
    DubboResult<List<SignActivityDto>> findByAppIdAndDeveloperId(long appId, long developerId);

    /**
     * 分页查询签到活动,分页信息非空
     *
     * @param param
     * @return
     */
    DubboResult<Page<SignActivityDto>> pageSearch(SignActivityQueryParam param);


    /**
     * 更新签到活动状态
     *
     * @param id
     * @param status
     * @return
     */
    DubboResult<Boolean> updateStatus(long id, SignActivityStatusEnum status);

    /**
     * 定向开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    DubboResult<Boolean> directSwitch(long id, boolean switchOpen);

    /**
     * 黑名单开关切换
     *
     * @param switchOpen 目标开关状态
     * @return
     */
    DubboResult<Boolean> blackSwitch(long id, boolean switchOpen);
}
