package cn.com.duiba.activity.center.api.remoteservice.sign.system;

import cn.com.duiba.activity.center.api.dto.sign.system.SignCalendarRuleDto;
import cn.com.duiba.activity.center.api.dto.sign.system.SignConstellationRuleDto;
import cn.com.duiba.activity.center.api.dto.sign.system.SignRuleDto;
import cn.com.duiba.activity.center.api.enums.ConstellationTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignActivityTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 签到活动规则
 * Created by xiaoxuda on 2017/4/21.
 */
public interface RemoteSignRuleService {
    /**
     * 批量插入规则,如果规则已存在则更新规则
     *
     * @param signType       活动类型，必填
     * @param signActivityId 活动ID,必填
     * @param list
     * @return
     */
    <T extends SignRuleDto> DubboResult<Boolean> batchInsertOrUpdate(SignActivityTypeEnum signType, long signActivityId,
                                     List<T> list);

    /**
     * 通过签到活动类型与活动id查询关联的所有活动规则,按签到日期倒叙排列
     *
     * @param signType
     * @param signActivityId
     * @return
     */
    <T extends SignRuleDto> DubboResult<List<T>> findByTypeAndActivityIdOrderByDayDesc(SignActivityTypeEnum signType,
                                                                         long signActivityId);


    /**
     * 通过星座类型与活动id及日期，查询对应签到星座规则
     *
     * @param constellationType
     * @param signActivityId
     * @param signDate       yyyy-MM-dd格式
     * @return
     */
    DubboResult<SignConstellationRuleDto> findByConstellationTypeAndActivityIdAndDay(long signActivityId,
                                                                                     ConstellationTypeEnum constellationType,
                                                                                     String signDate);


    /**
     * 通过星座类型与活动id查询时间最远的一条签到规则,用于根据具体日期查询不到签到规则时作为应急数据
     *
     * @param constellationType
     * @param signActivityId
     * @return
     */
    DubboResult<SignConstellationRuleDto> findOldestOneByConstellationTypeAndActivityId(long signActivityId,
                                                                           ConstellationTypeEnum constellationType);

    /**
     * 单条插入规则
     * @param signType
     * @param <T>
     * @return
     */
    <T extends SignRuleDto> DubboResult<Boolean> insertOrUpdate(Long signActivityId,SignActivityTypeEnum signType, T t);

    /**
     * 根据区间查询规则
     * @param signActivityId
     * @param advancedTime
     * @param lastTime
     * @return
     */
    DubboResult<List<SignCalendarRuleDto>> findRuleBySection(long signActivityId, String advancedTime, String lastTime,SignActivityTypeEnum signType);


    /**
     * 查询当天的签到信息
     * @param signActivityId
     * @param date
     * @param signType
     * @param <T>
     * @return
     */
    <T extends SignRuleDto> DubboResult<T> getSingleRuleByDateAndActivityId(Long signActivityId, String date,SignActivityTypeEnum signType);
}
