package cn.com.duiba.activity.center.api.tool;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public class SwitchTool {
    /**
     * 判断给定开关集合中是否包含给定switchInt
     * @param switches
     * @param switchInt
     * @return
     */
    public static boolean switchIsOpen(Integer switches, Integer switchInt){
        if(switches == null || switchInt == null){
            return false;
        }
        int v = 1 << switchInt;
        int ret = switches & v;
        return ret != 0;
    }

    /**
     * 在开关集合中打开switchInt指定的开关
     * @param switches
     * @param switchInt
     * @return
     */
    public static Integer openSwitch(Integer switches, Integer switchInt){
        if(switches == null){
            switches = 0;
        }
        if(switchInt == null){
            return switches;
        }
        int v = 1 << switchInt;
        return switches | v;
    }

    /**
     * 在开关集合中关闭switchInt指定的开关
     * @param switches
     * @param switchInt
     * @return
     */
    public static Integer closeSwitch(Integer switches, Integer switchInt){
        if(switches == null){
            switches = 0;
        }
        if(switchInt == null){
            return switches;
        }
        int v = 1 << switchInt;
        return switches & (~v);
    }

}
