package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.DateUnit;
import cn.com.duiba.activity.center.api.enums.ReSignAwardTypeEnum;
import cn.com.duiba.activity.center.api.enums.ReSignConsumeTypeEnum;

import java.io.Serializable;

/**
 * Created by xiaoxuda on 2017/8/11.
 */
public class ReSignRuleConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = -4774359074497734071L;

    /**
     * 补签时间周期
     */
    private DateUnit dateUnit;
    /**
     * 自定义补签周期，最大支持31天
     */
    private Integer days;
    /**
     * 补签消耗方式
     */
    private ReSignConsumeTypeEnum conType;
    /**
     * 补签消耗积分
     */
    private Integer credits;
    /**
     * 补签消耗补签卡
     */
    private Integer card;
    /**
     * 扣补签卡接口
     */
    private String conUrl;
    /**
     * 补签奖励方式
     */
    private ReSignAwardTypeEnum awardType;
    /**
     * 周期内补签次数限制
     */
    private Integer countLimit;

    /**
     * 获取消耗数量
     * @param consumeType
     * @return
     */
    public Integer getConsumeCount(ReSignConsumeTypeEnum consumeType){
        if(ReSignConsumeTypeEnum.CREDITS.equals(consumeType)){
            return credits;
        }else if(ReSignConsumeTypeEnum.RESIGN_CARD.equals(consumeType)){
            return card;
        }
        return 0;
    }

    public DateUnit getDateUnit() {
        return dateUnit;
    }

    public void setDateUnit(DateUnit dateUnit) {
        this.dateUnit = dateUnit;
    }

    public Integer getDays() {
        return days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public ReSignConsumeTypeEnum getConType() {
        return conType;
    }

    public void setConType(ReSignConsumeTypeEnum conType) {
        this.conType = conType;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getCard() {
        return card;
    }

    public void setCard(Integer card) {
        this.card = card;
    }

    public String getConUrl() {
        return conUrl;
    }

    public void setConUrl(String conUrl) {
        this.conUrl = conUrl;
    }

    public ReSignAwardTypeEnum getAwardType() {
        return awardType;
    }

    public void setAwardType(ReSignAwardTypeEnum awardType) {
        this.awardType = awardType;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }
}
