/**
 * Project Name:activity-center-api
 * File Name:RemoteTodayRobSeckillSpecifyService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.rob
 * Date:2017年3月30日上午10:30:56
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.rob;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillSpecifyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteTodayRobSeckillSpecifyService <br/>
 * 秒杀区间定向配置dubbo服务
 * Date:     2017年3月30日 上午10:30:56 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteTodayRobSeckillSpecifyService {
    
    /**
     * 更新秒杀区间定向配置
     *
     * @author zhanglihui
     * @param todayRobSeckillId
     * @param list
     * @return DubboResult
     */
    DubboResult<Void> updateSpecify(long todayRobSeckillId, List<TodayRobSeckillSpecifyDto> list);
    
    /**
     * 根据秒杀区间ID查询定向配置信息
     *
     * @author zhanglihui
     * @param todayRobSeckillId 秒杀区间主键
     * @return 定向配置列表
     */
    DubboResult<List<TodayRobSeckillSpecifyDto>> selectByTodayRobSeckillId(long todayRobSeckillId);
}

