package cn.com.duiba.activity.center.api.dto.sign;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.SignTypeEnum;
import com.alibaba.fastjson.JSONObject;

/**
 * 用户签到信息
 * Created by xiaoxuda on 2017/6/5.
 */
public class SignInfoDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = -3868872593660301324L;

    /**
     * 今日签到状态
     */
    private Boolean todaySigned = false;

    /**
     * 签到类型
     */
    private SignTypeEnum signType;

    /**
     * 连续签到天数
     */
    private Integer continueDay;

    /**
     * 奖励的总积分
     */
    private Integer credits = 0;
    /**
     * 奖励的积分明细
     */
    private JSONObject creditsDetail = new JSONObject();
    /**
     * 奖励的总活动次数
     */
    private Integer activityCount = 0;
    /**
     * 奖励的活动次数明细
     */
    private JSONObject countDetail = new JSONObject();

    /**
     * 明日签到可得积分
     */
    private Integer creditsTomorrow;

    /**
     * 明日签到可得抽奖次数
     */
    private Integer activityCountTomorrow;
    /**
     * 用户第一次签到的时间
     */
    private Date firstSignDate;
    /**
     * 用户在该签到下面坚持的天数
     */
    private Integer lastDays;
    /**
     * 是否有累积奖励
     */
    private Boolean hasAcmReward;

    public Boolean getTodaySigned() {
        return todaySigned;
    }

    public void setTodaySigned(Boolean todaySigned) {
        this.todaySigned = todaySigned;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getCreditsTomorrow() {
        return creditsTomorrow;
    }

    public void setCreditsTomorrow(Integer creditsTomorrow) {
        this.creditsTomorrow = creditsTomorrow;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public Integer getActivityCountTomorrow() {
        return activityCountTomorrow;
    }

    public void setActivityCountTomorrow(Integer activityCountTomorrow) {
        this.activityCountTomorrow = activityCountTomorrow;
    }

    public Date getFirstSignDate() {
        return firstSignDate;
    }

    public void setFirstSignDate(Date firstSignDate) {
        this.firstSignDate = firstSignDate;
    }

    public Integer getLastDays() {
        return lastDays;
    }

    public void setLastDays(Integer lastDays) {
        this.lastDays = lastDays;
    }

    public Boolean getHasAcmReward() {
        return hasAcmReward;
    }

    public JSONObject getCreditsDetail() {
        return creditsDetail;
    }

    public void setCreditsDetail(JSONObject creditsDetail) {
        this.creditsDetail = creditsDetail;
    }

    public JSONObject getCountDetail() {
        return countDetail;
    }

    public void setCountDetail(JSONObject countDetail) {
        this.countDetail = countDetail;
    }

    public void setHasAcmReward(Boolean hasAcmReward) {
        this.hasAcmReward = hasAcmReward;
    }
}
