package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.enums.ActivityTimeValidityTypeEnum;
import cn.com.duiba.activity.center.api.enums.SignRewardTypeEnum;

import java.io.Serializable;
import java.util.List;

/**
 * 签到奖励规则配置
 * Created by xiaoxuda on 2017/11/14.
 */
public class SignRewardRuleDto implements Serializable {
    private static final long serialVersionUID = -5178753084910923609L;

    /**
     * 奖励规则开关是否打开
     */
    private Boolean open;
    /**
     * 奖励类型
     */
    private SignRewardTypeEnum rwType;
    /**
     * 奖励规则
     */
    private List<SignRuleItemDto> items;
    /**
     * 插件活动ID
     */
    private Long plAcId;
    /**
     * 插件活动皮肤ID
     */
    private Long plAcSkId;
    /**
     * 插件活动有效期类型
     */
    private ActivityTimeValidityTypeEnum plAcType;

    public Boolean getOpen() {
        return open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public SignRewardTypeEnum getRwType() {
        return rwType;
    }

    public void setRwType(SignRewardTypeEnum rwType) {
        this.rwType = rwType;
    }

    public List<SignRuleItemDto> getItems() {
        return items;
    }

    public void setItems(List<SignRuleItemDto> items) {
        this.items = items;
    }

    public Long getPlAcId() {
        return plAcId;
    }

    public void setPlAcId(Long plAcId) {
        this.plAcId = plAcId;
    }

    public Long getPlAcSkId() {
        return plAcSkId;
    }

    public void setPlAcSkId(Long plAcSkId) {
        this.plAcSkId = plAcSkId;
    }

    public ActivityTimeValidityTypeEnum getPlAcType() {
        return plAcType;
    }

    public void setPlAcType(ActivityTimeValidityTypeEnum plAcType) {
        this.plAcType = plAcType;
    }
}
