package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.dto.sign.SignRewardRuleDto;
import cn.com.duiba.activity.center.api.dto.sign.SignRuleItemDto;
import cn.com.duiba.activity.center.api.exception.ActivityCenterException;
import org.apache.commons.collections.CollectionUtils;

import java.util.Objects;

/**
 * 签到奖励类型
 * Created by xiaoxuda on 2017/11/14.
 */
public enum SignRewardTypeEnum {
    CONTINUE(1, "连续奖励") {
        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay > circle ? circle : continueDay;
            return rewardRule.getItems().get(index - 1);
        }
    },
    CIRCLE(2, "周期奖励") {
        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            int circle = rewardRule.getItems().size();
            int index = continueDay % circle;
            index = index == 0 ? circle : index;
            return rewardRule.getItems().get(index - 1);
        }
    },
    ACCUMULATE(3, "累计奖励") {
        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            for (SignRuleItemDto item : rewardRule.getItems()) {
                if (item.getDays() == null) {
                    continue;
                }
                if (Objects.equals(item.getDays(), continueDay)) {
                    return item;
                }
            }
            return new SignRuleItemDto();
        }
    },
    SPEC_DAY(4, "特殊日期奖励"){
        @Override
        protected SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule) {
            //需要外部单独写处理逻辑
            return new SignRuleItemDto();
        }
    };

    private Integer code;
    private String desc;

    SignRewardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据签到规则计算连续签到第continueDay天所适用的签到奖励条目
     *
     * @param continueDay    签到完成后周期内连续签到天数,累积奖励时需要传入周期内累计的签到天数
     * @param rewardRule 奖励规则
     * @return
     */
    public SignRuleItemDto getRuleItem(Integer continueDay, SignRewardRuleDto rewardRule) {
        if (continueDay < 0 || rewardRule == null ) {
            throw new ActivityCenterException("参数非法");
        }
        if(!Boolean.TRUE.equals(rewardRule.getOpen()) || CollectionUtils.isEmpty(rewardRule.getItems())){
            return new SignRuleItemDto();
        }
        return this.getRuleItemSub(continueDay , rewardRule);
    }

    protected abstract SignRuleItemDto getRuleItemSub(int continueDay, SignRewardRuleDto rewardRule);

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
