package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.activity.ActivityWinnerCarouselDto;

import java.util.Date;
import java.util.List;

/**
 * 活动中奖小广播服务
 * Created by hww on 2017/10/25
 */
public interface RemoteActivityWinnerCarouselService {

    /**
     * 查询中奖名单
     * @param operatingActivityId 活动id
     * @param gmtCreate 时间参数，查询之后的记录
     * @param count 查询数量
     * @return
     */
    List<ActivityWinnerCarouselDto> findByOperationActivityId(Long operatingActivityId, Date gmtCreate, Integer count);

    /**
     * 写入中奖小广播新数据
     * @param activityWinnerCarouselDto
     * @return 返回自增id
     */
    Long insertWinnerCarousel(ActivityWinnerCarouselDto activityWinnerCarouselDto);

    /**
     * 获取中奖名单
     * @param ids  活动id集合
     * @param count 查询数量
     * @param originType 中奖信息来源
     * @param appId 应用id
     * @param gmtCreate 中奖时间
     * @return
     */
    List<ActivityWinnerCarouselDto> findByWinnerReq(List<String> ids, Integer count, Integer originType, Long appId, Date gmtCreate);


}
