package cn.com.duiba.activity.center.api.remoteservice.activity;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.activity.QuestionRecordDto;

/**
 * Created by yansen on 16/6/12.
 */
public interface RemoteOperatingActivityOptionsService {


    //from HdtoolSimpleDAO

    /**
     * 
     * findOptionById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityOptionsDto findOptionById(Long id);

    /**
     * 
     * findByOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId);

    /**
     * 
     * countByOperatingActivityId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityId
     * @return
     * @since JDK 1.6
     */
    public Integer countByOperatingActivityId(Long operatingActivityId);

    //from HdtoolTextChangeDAO

    /**
     * 
     * decrementOptionRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param optionId
     * @return
     * @since JDK 1.6
     */
    public int decrementOptionRemaining(Long optionId);

    /**
     * 
     * incrementOptionRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param optionId
     * @return
     * @since JDK 1.6
     */
    public int incrementOptionRemaining(Long optionId);

    /**
     * 
     * updateOptionDeleteStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param oaoList
     * @return
     * @since JDK 1.6
     */
    public int updateOptionDeleteStatus(List<Long> oaoList);

    /**
     * 
     * updatePrize:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityOptionsDO
     * @return
     * @since JDK 1.6
     */
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDO);

    /**
     * 
     * insertOption:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityOptionsDO
     * @return
     * @since JDK 1.6
     */
    public OperatingActivityOptionsDto insertOption(OperatingActivityOptionsDto operatingActivityOptionsDO);

    /**
     * 
     * updateOption:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param operatingActivityOptionsDO
     * @return
     * @since JDK 1.6
     */
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDO);

    //from OperatingActivityOptionsStatusChangeDAO
    
    /**
     * 
     * addRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 增加奖品数量
     * @param id
     * @param addRemaining
     * @return
     * @since JDK 1.6
     */
    public int addRemainingById(Long id, Integer addRemaining);

    /**
     * 
     * subRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 减少奖品数量
     * @param id
     * @param subRemaining
     * @return
     * @since JDK 1.6
     */
    public int subRemainingById(Long id, Integer subRemaining);

    /**
     * 
     * updateRemainingById:(这里用一句话描述这个方法的作用). <br/>
     * 更新库存
     * @param id
     * @param remaining
     * @return
     * @since JDK 1.6
     */
    public int updateRemainingById(Long id, Integer remaining);

    /**
     * 
     * findRemaingForupdate:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public Integer findRemaingForupdate(Long id);

    /**
     * 
     * findByQuestionRecordId:(这里用一句话描述这个方法的作用). <br/>
     * 查询答题题目信息
     * from developer
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    public List<QuestionRecordDto> findByQuestionRecordId(Long activityId);

    /**
     * 保存或编辑答题题目信息
     * from developer
     * @param activityId
     * @param questionRecord
     * @param optionNum
     * @throws Exception
     */
    public void saveOrUpdateQuestionRecord(Long activityId, String[] questionRecord,int optionNum);
}
